/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceFilter;
import cn.taketoday.core.style.ToStringBuilder;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;

public class ResourceDecorator
implements Resource {
    protected Resource delegate;

    protected ResourceDecorator() {
    }

    public ResourceDecorator(Resource delegate) {
        Assert.notNull((Object)delegate, "Resource delegate is required");
        this.delegate = delegate;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getDelegate().getInputStream();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getDelegate().getReader();
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return this.getDelegate().getReader(encoding);
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        return this.getDelegate().readableChannel();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public long contentLength() throws IOException {
        return this.getDelegate().contentLength();
    }

    @Override
    public long lastModified() throws IOException {
        return this.getDelegate().lastModified();
    }

    @Override
    public URL getURL() throws IOException {
        return this.getDelegate().getURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.getDelegate().getURI();
    }

    @Override
    public File getFile() throws IOException {
        return this.getDelegate().getFile();
    }

    @Override
    public boolean exists() {
        try {
            return this.getDelegate().exists();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public boolean isReadable() {
        return this.getDelegate().isReadable();
    }

    @Override
    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    @Override
    public boolean isFile() {
        return this.getDelegate().isFile();
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.getDelegate().isDirectory();
    }

    @Override
    public String[] list() throws IOException {
        return this.getDelegate().list();
    }

    @Override
    public Resource[] list(@Nullable ResourceFilter filter) throws IOException {
        return this.getDelegate().list(filter);
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        return this.getDelegate().createRelative(relativePath);
    }

    public Resource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Resource delegate) {
        this.delegate = delegate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResourceDecorator) {
            ResourceDecorator decorator = (ResourceDecorator)obj;
            return Objects.equals(decorator.delegate, this.delegate);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    @Override
    public String toString() {
        return ToStringBuilder.from(this).append("delegate", this.delegate).toString();
    }
}

