/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceFilter;
import cn.taketoday.core.style.ToStringBuilder;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ResourceUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Objects;

public abstract class AbstractResource
implements Resource {
    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public boolean exists() {
        Logger log;
        block6: {
            if (this.isFile()) {
                try {
                    return this.getFile().exists();
                }
                catch (IOException ex) {
                    log = this.getLogger();
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Could not retrieve File for existence check of " + this, (Throwable)ex);
                }
            }
        }
        try {
            this.getInputStream().close();
            return true;
        }
        catch (Throwable ex) {
            log = this.getLogger();
            if (log.isDebugEnabled()) {
                log.debug("Could not retrieve InputStream for existence check of " + this, ex);
            }
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        return this.exists();
    }

    protected void customizeConnection(URLConnection con) throws IOException {
        ResourceUtils.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            this.customizeConnection((HttpURLConnection)con);
        }
    }

    protected void customizeConnection(HttpURLConnection con) throws IOException {
        con.setRequestMethod("HEAD");
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this + " cannot be resolved to URL");
    }

    @Override
    public URI getURI() throws IOException {
        URL location = this.getURL();
        try {
            return location.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI [" + location + "]", ex);
        }
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this + " cannot be resolved to absolute file path");
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.getFile().isDirectory();
    }

    @Override
    public String[] list() throws IOException {
        return this.getFile().list();
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        Object[] names = this.list();
        if (ObjectUtils.isEmpty(names)) {
            return EMPTY_ARRAY;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Object name : names) {
            Resource resource = this.createRelative((String)name);
            if (filter != null && !filter.accept(resource)) continue;
            resources.add(resource);
        }
        if (resources.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return resources.toArray(Resource.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long contentLength() throws IOException {
        InputStream is = this.getInputStream();
        try {
            int read;
            long size = 0L;
            byte[] buf = new byte[256];
            while ((read = is.read(buf)) != -1) {
                size += (long)read;
            }
            long l = size;
            return l;
        }
        finally {
            block8: {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger log = this.getLogger();
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Could not close content-length InputStream for " + this, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public long lastModified() throws IOException {
        File fileToCheck = this.getFileForLastModifiedCheck();
        long lastModified = fileToCheck.lastModified();
        if (lastModified == 0L && !fileToCheck.exists()) {
            throw new FileNotFoundException(this + " cannot be resolved in the file system for checking its last-modified timestamp");
        }
        return lastModified;
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException(this + " cannot be resolved relative file path for " + relativePath);
    }

    @Override
    public String toString() {
        try {
            return ToStringBuilder.from(this).append("name", this.getName()).append("location", this.getURL()).toString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource resource = (Resource)obj;
            try {
                URL location = this.getURL();
                URL otherLocation = resource.getURL();
                return Objects.equals(location, otherLocation);
            }
            catch (Exception exception) {
                return Objects.equals(this.toString(), obj.toString());
            }
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

