/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.lang.Nullable;
import java.util.Set;

final class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final Set<String> trueValues = Set.of("true", "on", "yes", "1");
    private static final Set<String> falseValues = Set.of("false", "off", "no", "0");

    StringToBooleanConverter() {
    }

    @Override
    @Nullable
    public Boolean convert(String source) {
        String value = source.trim();
        if (value.isEmpty()) {
            return null;
        }
        if (trueValues.contains(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
    }
}

