/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConversionFailedException;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;

abstract class ConversionUtils {
    ConversionUtils() {
    }

    @Nullable
    public static Object invokeConverter(GenericConverter converter, @Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return converter.convert(source, sourceType, targetType);
        }
        catch (ConversionFailedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
    }

    public static boolean canConvertElements(@Nullable TypeDescriptor sourceElementType, @Nullable TypeDescriptor targetElementType, ConversionService conversionService) {
        if (targetElementType == null) {
            return true;
        }
        if (sourceElementType == null) {
            return true;
        }
        if (conversionService.canConvert(sourceElementType, targetElementType)) {
            return true;
        }
        return ClassUtils.isAssignable(sourceElementType.getType(), targetElementType.getType());
    }
}

