/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.codec;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.codec.AbstractEncoder;
import cn.taketoday.core.codec.Hints;
import cn.taketoday.core.io.buffer.DataBuffer;
import cn.taketoday.core.io.buffer.DataBufferFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.MimeType;
import cn.taketoday.util.MimeTypeUtils;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ByteArrayEncoder
extends AbstractEncoder<byte[]> {
    public ByteArrayEncoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<?> clazz = elementType.toClass();
        return super.canEncode(elementType, mimeType) && byte[].class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends byte[]> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(inputStream).map(bytes -> this.encodeValue((byte[])bytes, bufferFactory, elementType, mimeType, hints));
    }

    @Override
    public DataBuffer encodeValue(byte[] bytes, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        DataBuffer dataBuffer = bufferFactory.wrap(bytes);
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            this.logger.debug("{}Writing {} bytes", (Object)Hints.getLogPrefix(hints), (Object)dataBuffer.readableByteCount());
        }
        return dataBuffer;
    }
}

