/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum IntrospectionFailureLogger {
    DEBUG{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isDebugEnabled();
        }

        @Override
        public void log(String message) {
            IntrospectionFailureLogger.getLogger().debug(message);
        }
    }
    ,
    INFO{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isInfoEnabled();
        }

        @Override
        public void log(String message) {
            IntrospectionFailureLogger.getLogger().info(message);
        }
    };

    @Nullable
    private static Logger logger;

    void log(String message, @Nullable Object source, Exception ex) {
        Object on = source != null ? " on " + source : "";
        this.log(message + (String)on + ": " + ex);
    }

    abstract boolean isEnabled();

    abstract void log(String var1);

    private static Logger getLogger() {
        Logger logger = IntrospectionFailureLogger.logger;
        if (logger == null) {
            IntrospectionFailureLogger.logger = logger = LoggerFactory.getLogger(IntrospectionFailureLogger.class);
        }
        return logger;
    }
}

