/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.annotation.AliasFor;
import cn.taketoday.core.annotation.AnnotationConfigurationException;
import cn.taketoday.core.annotation.AnnotationTypeMappings;
import cn.taketoday.core.annotation.AnnotationsScanner;
import cn.taketoday.core.annotation.AttributeMethods;
import cn.taketoday.core.annotation.TypeMappedAnnotation;
import cn.taketoday.core.annotation.ValueExtractor;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class AnnotationTypeMapping {
    private static final MirrorSets.MirrorSet[] EMPTY_MIRROR_SETS = new MirrorSets.MirrorSet[0];
    @Nullable
    public final AnnotationTypeMapping source;
    public final AnnotationTypeMapping root;
    public final int distance;
    public final Class<? extends Annotation> annotationType;
    public final List<Class<? extends Annotation>> metaTypes;
    @Nullable
    public final Annotation annotation;
    public final AttributeMethods methods;
    public final MirrorSets mirrorSets;
    private final int[] aliasMappings;
    private final int[] conventionMappings;
    private final int[] annotationValueMappings;
    private final AnnotationTypeMapping[] annotationValueSource;
    private final Map<Method, List<Method>> aliasedBy;
    public final boolean synthesizable;
    private final Set<Method> claimedAliases = new HashSet<Method>();

    AnnotationTypeMapping(@Nullable AnnotationTypeMapping source, Class<? extends Annotation> annotationType, @Nullable Annotation annotation, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        this.source = source;
        this.annotation = annotation;
        this.annotationType = annotationType;
        this.root = source != null ? source.root : this;
        this.distance = source == null ? 0 : source.distance + 1;
        this.metaTypes = AnnotationTypeMapping.merge(source != null ? source.metaTypes : null, annotationType);
        this.methods = AttributeMethods.forAnnotationType(annotationType);
        this.mirrorSets = new MirrorSets();
        this.aliasMappings = AnnotationTypeMapping.filledIntArray(this.methods.size());
        this.conventionMappings = AnnotationTypeMapping.filledIntArray(this.methods.size());
        this.annotationValueMappings = AnnotationTypeMapping.filledIntArray(this.methods.size());
        this.annotationValueSource = new AnnotationTypeMapping[this.methods.size()];
        this.aliasedBy = this.resolveAliasedForTargets();
        this.processAliases();
        this.addConventionMappings();
        this.addConventionAnnotationValues();
        this.synthesizable = this.computeSynthesizableFlag(visitedAnnotationTypes);
    }

    private static <T> List<T> merge(@Nullable List<T> existing, T element) {
        if (existing == null) {
            return Collections.singletonList(element);
        }
        ArrayList<T> merged = new ArrayList<T>(existing.size() + 1);
        merged.addAll(existing);
        merged.add(element);
        return Collections.unmodifiableList(merged);
    }

    private Map<Method, List<Method>> resolveAliasedForTargets() {
        HashMap<Method, List> aliasedBy = new HashMap<Method, List>();
        for (Method attribute : this.methods.attributes) {
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(attribute, AliasFor.class);
            if (aliasFor == null) continue;
            Method target = this.resolveAliasTarget(attribute, aliasFor);
            aliasedBy.computeIfAbsent(target, key -> new ArrayList()).add(attribute);
        }
        return Collections.unmodifiableMap(aliasedBy);
    }

    private Method resolveAliasTarget(Method attribute, AliasFor aliasFor) {
        return this.resolveAliasTarget(attribute, aliasFor, true);
    }

    private Method resolveAliasTarget(Method attribute, AliasFor aliasFor, boolean checkAliasPair) {
        Method mirror;
        AliasFor targetAliasFor;
        Method target;
        String targetAttributeName;
        if (StringUtils.hasText(aliasFor.value()) && StringUtils.hasText(aliasFor.attribute())) {
            throw new AnnotationConfigurationException(String.format("In @AliasFor declared on %s, attribute 'attribute' and its alias 'value' are present with values of '%s' and '%s', but only one is permitted.", AttributeMethods.describe(attribute), aliasFor.attribute(), aliasFor.value()));
        }
        Class<? extends Annotation> targetAnnotation = aliasFor.annotation();
        if (targetAnnotation == Annotation.class) {
            targetAnnotation = this.annotationType;
        }
        if (StringUtils.isEmpty(targetAttributeName = aliasFor.attribute())) {
            targetAttributeName = aliasFor.value();
        }
        if (StringUtils.isEmpty(targetAttributeName)) {
            targetAttributeName = attribute.getName();
        }
        if ((target = AttributeMethods.forAnnotationType(targetAnnotation).get(targetAttributeName)) == null) {
            if (targetAnnotation == this.annotationType) {
                throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s declares an alias for '%s' which is not present.", AttributeMethods.describe(attribute), targetAttributeName));
            }
            throw new AnnotationConfigurationException(String.format("%s is declared as an @AliasFor nonexistent %s.", StringUtils.capitalize(AttributeMethods.describe(attribute)), AttributeMethods.describe(targetAnnotation, targetAttributeName)));
        }
        if (target.equals(attribute)) {
            throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s points to itself. Specify 'annotation' to point to a same-named attribute on a meta-annotation.", AttributeMethods.describe(attribute)));
        }
        if (!this.isCompatibleReturnType(attribute.getReturnType(), target.getReturnType())) {
            throw new AnnotationConfigurationException(String.format("Mis-configured aliases: %s and %s must declare the same return type.", AttributeMethods.describe(attribute), AttributeMethods.describe(target)));
        }
        if (this.isAliasPair(target) && checkAliasPair && (targetAliasFor = target.getAnnotation(AliasFor.class)) != null && !(mirror = this.resolveAliasTarget(target, targetAliasFor, false)).equals(attribute)) {
            throw new AnnotationConfigurationException(String.format("%s must be declared as an @AliasFor %s, not %s.", StringUtils.capitalize(AttributeMethods.describe(target)), AttributeMethods.describe(attribute), AttributeMethods.describe(mirror)));
        }
        return target;
    }

    private boolean isAliasPair(Method target) {
        return this.annotationType == target.getDeclaringClass();
    }

    private boolean isCompatibleReturnType(Class<?> attributeType, Class<?> targetType) {
        return attributeType == targetType || attributeType == targetType.getComponentType();
    }

    private void processAliases() {
        ArrayList<Method> aliases = new ArrayList<Method>();
        Method[] attributes = this.methods.attributes;
        for (int i = 0; i < attributes.length; ++i) {
            aliases.clear();
            aliases.add(attributes[i]);
            this.collectAliases(aliases);
            if (aliases.size() <= 1) continue;
            this.processAliases(i, aliases);
        }
    }

    private void collectAliases(List<Method> aliases) {
        AnnotationTypeMapping mapping = this;
        while (mapping != null) {
            int size = aliases.size();
            for (int j = 0; j < size; ++j) {
                List<Method> additional = mapping.aliasedBy.get(aliases.get(j));
                if (additional == null) continue;
                aliases.addAll(additional);
            }
            mapping = mapping.source;
        }
    }

    private void processAliases(int attributeIndex, ArrayList<Method> aliases) {
        int rootAttributeIndex = this.getFirstRootAttributeIndex(aliases);
        AnnotationTypeMapping mapping = this;
        while (mapping != null) {
            if (rootAttributeIndex != -1 && mapping != this.root) {
                Method[] attributes = mapping.methods.attributes;
                for (int i = 0; i < attributes.length; ++i) {
                    if (!aliases.contains(attributes[i])) continue;
                    mapping.aliasMappings[i] = rootAttributeIndex;
                }
            }
            mapping.mirrorSets.updateFrom(aliases);
            mapping.claimedAliases.addAll(aliases);
            if (mapping.annotation != null) {
                int[] resolvedMirrors = mapping.mirrorSets.resolve(null, mapping.annotation, ReflectionUtils::invokeMethod);
                Method[] attributes = mapping.methods.attributes;
                for (int i = 0; i < attributes.length; ++i) {
                    if (!aliases.contains(attributes[i])) continue;
                    this.annotationValueMappings[attributeIndex] = resolvedMirrors[i];
                    this.annotationValueSource[attributeIndex] = mapping;
                }
            }
            mapping = mapping.source;
        }
    }

    private int getFirstRootAttributeIndex(ArrayList<Method> aliases) {
        Method[] rootAttributes = this.root.methods.attributes;
        for (int i = 0; i < rootAttributes.length; ++i) {
            if (!aliases.contains(rootAttributes[i])) continue;
            return i;
        }
        return -1;
    }

    private void addConventionMappings() {
        if (this.distance == 0) {
            return;
        }
        int[] mappings = this.conventionMappings;
        Method[] attributes = this.methods.attributes;
        AttributeMethods rootMethods = this.root.methods;
        for (int i = 0; i < mappings.length; ++i) {
            String name = attributes[i].getName();
            int mapped = rootMethods.indexOf(name);
            if ("value".equals(name) || mapped == -1) continue;
            MirrorSets.MirrorSet mirrors = this.mirrorSets.getAssigned(i);
            mappings[i] = mapped;
            if (mirrors == null) continue;
            for (int j = 0; j < mirrors.size; ++j) {
                mappings[mirrors.getAttributeIndex((int)j)] = mapped;
            }
        }
    }

    private void addConventionAnnotationValues() {
        Method[] attributes = this.methods.attributes;
        for (int i = 0; i < attributes.length; ++i) {
            Method attribute = attributes[i];
            boolean isValueAttribute = "value".equals(attribute.getName());
            AnnotationTypeMapping mapping = this;
            while (mapping != null && mapping.distance > 0) {
                int mapped = mapping.methods.indexOf(attribute.getName());
                if (mapped != -1 && this.isBetterConventionAnnotationValue(i, isValueAttribute, mapping)) {
                    this.annotationValueMappings[i] = mapped;
                    this.annotationValueSource[i] = mapping;
                }
                mapping = mapping.source;
            }
        }
    }

    private boolean isBetterConventionAnnotationValue(int index, boolean isValueAttribute, AnnotationTypeMapping mapping) {
        if (this.annotationValueMappings[index] == -1) {
            return true;
        }
        int existingDistance = this.annotationValueSource[index].distance;
        return !isValueAttribute && existingDistance > mapping.distance;
    }

    private boolean computeSynthesizableFlag(Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        visitedAnnotationTypes.add(this.annotationType);
        for (int index : this.aliasMappings) {
            if (index == -1) continue;
            return true;
        }
        if (!this.aliasedBy.isEmpty()) {
            return true;
        }
        for (int index : this.conventionMappings) {
            if (index == -1) continue;
            return true;
        }
        if (this.methods.hasNestedAnnotation) {
            for (Method attribute : this.methods.attributes) {
                Class<?> annotationType;
                Class<?> type = attribute.getReturnType();
                if (!type.isAnnotation() && (!type.isArray() || !type.getComponentType().isAnnotation())) continue;
                Class<?> clazz = annotationType = type.isAnnotation() ? type : type.getComponentType();
                if (!visitedAnnotationTypes.add(annotationType)) continue;
                AnnotationTypeMapping mapping = AnnotationTypeMappings.forAnnotationType(annotationType, visitedAnnotationTypes).get(0);
                if (!mapping.synthesizable) continue;
                return true;
            }
        }
        return false;
    }

    void afterAllMappingsSet() {
        this.validateAllAliasesClaimed();
        for (MirrorSets.MirrorSet mirrorSet : this.mirrorSets.mirrorSets) {
            this.validateMirrorSet(mirrorSet);
        }
        this.claimedAliases.clear();
    }

    private void validateAllAliasesClaimed() {
        for (Method attribute : this.methods.attributes) {
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(attribute, AliasFor.class);
            if (aliasFor == null || this.claimedAliases.contains(attribute)) continue;
            Method target = this.resolveAliasTarget(attribute, aliasFor);
            throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s declares an alias for %s which is not meta-present.", AttributeMethods.describe(attribute), AttributeMethods.describe(target)));
        }
    }

    private void validateMirrorSet(MirrorSets.MirrorSet mirrorSet) {
        Method firstAttribute = mirrorSet.get(0);
        Object firstDefaultValue = firstAttribute.getDefaultValue();
        for (int i = 1; i <= mirrorSet.size - 1; ++i) {
            Method mirrorAttribute = mirrorSet.get(i);
            Object mirrorDefaultValue = mirrorAttribute.getDefaultValue();
            if (firstDefaultValue == null || mirrorDefaultValue == null) {
                throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare default values.", AttributeMethods.describe(firstAttribute), AttributeMethods.describe(mirrorAttribute)));
            }
            if (ObjectUtils.nullSafeEquals(firstDefaultValue, mirrorDefaultValue)) continue;
            throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare the same default value.", AttributeMethods.describe(firstAttribute), AttributeMethods.describe(mirrorAttribute)));
        }
    }

    Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    int getAliasMapping(int attributeIndex) {
        return this.aliasMappings[attributeIndex];
    }

    int getConventionMapping(int attributeIndex) {
        return this.conventionMappings[attributeIndex];
    }

    @Nullable
    Object getMappedAnnotationValue(int attributeIndex, boolean metaAnnotationsOnly) {
        int mappedIndex = this.annotationValueMappings[attributeIndex];
        if (mappedIndex == -1) {
            return null;
        }
        AnnotationTypeMapping source = this.annotationValueSource[attributeIndex];
        if (source == this && metaAnnotationsOnly) {
            return null;
        }
        return ReflectionUtils.invokeMethod(source.methods.get(mappedIndex), source.annotation);
    }

    boolean isEquivalentToDefaultValue(int attributeIndex, Object value, ValueExtractor valueExtractor) {
        Method attribute = this.methods.get(attributeIndex);
        return AnnotationTypeMapping.isEquivalentToDefaultValue(attribute, value, valueExtractor);
    }

    private static int[] filledIntArray(int size) {
        int[] array = new int[size];
        Arrays.fill(array, -1);
        return array;
    }

    private static boolean isEquivalentToDefaultValue(Method attribute, Object value, ValueExtractor valueExtractor) {
        return AnnotationTypeMapping.areEquivalent(attribute.getDefaultValue(), value, valueExtractor);
    }

    private static boolean areEquivalent(@Nullable Object value, @Nullable Object extractedValue, ValueExtractor valueExtractor) {
        if (ObjectUtils.nullSafeEquals(value, extractedValue)) {
            return true;
        }
        if (value instanceof Class && extractedValue instanceof String) {
            return AnnotationTypeMapping.areEquivalent((Class)value, (String)extractedValue);
        }
        if (value instanceof Class[] && extractedValue instanceof String[]) {
            return AnnotationTypeMapping.areEquivalent((Class[])value, (String[])extractedValue);
        }
        if (value instanceof Annotation) {
            return AnnotationTypeMapping.areEquivalent((Annotation)value, extractedValue, valueExtractor);
        }
        return false;
    }

    private static boolean areEquivalent(Class<?>[] value, String[] extractedValue) {
        if (value.length != extractedValue.length) {
            return false;
        }
        for (int i = 0; i < value.length; ++i) {
            if (AnnotationTypeMapping.areEquivalent(value[i], extractedValue[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean areEquivalent(Class<?> value, String extractedValue) {
        return value.getName().equals(extractedValue);
    }

    private static boolean areEquivalent(Annotation annotation, @Nullable Object extractedValue, ValueExtractor valueExtractor) {
        AttributeMethods methods = AttributeMethods.forAnnotationType(annotation.annotationType());
        for (Method attribute : methods.attributes) {
            Object value2;
            Object value1 = ReflectionUtils.invokeMethod(attribute, annotation);
            if (extractedValue instanceof TypeMappedAnnotation) {
                TypeMappedAnnotation typeMappedAnno = (TypeMappedAnnotation)extractedValue;
                value2 = typeMappedAnno.getValue(attribute.getName()).orElse(null);
            } else {
                value2 = valueExtractor.extract(attribute, extractedValue);
            }
            if (AnnotationTypeMapping.areEquivalent(value1, value2, valueExtractor)) continue;
            return false;
        }
        return true;
    }

    final class MirrorSets {
        public MirrorSet[] mirrorSets;
        private final MirrorSet[] assigned;

        MirrorSets() {
            this.assigned = new MirrorSet[AnnotationTypeMapping.this.methods.size()];
            this.mirrorSets = EMPTY_MIRROR_SETS;
        }

        void updateFrom(Collection<Method> aliases) {
            MirrorSet mirrorSet = null;
            int size = 0;
            int last = -1;
            Method[] attributes = AnnotationTypeMapping.this.methods.attributes;
            Object[] assigned = this.assigned;
            for (int i = 0; i < attributes.length; ++i) {
                Method attribute = attributes[i];
                if (!aliases.contains(attribute)) continue;
                if (++size > 1) {
                    if (mirrorSet == null) {
                        mirrorSet = new MirrorSet();
                        assigned[last] = mirrorSet;
                    }
                    assigned[i] = mirrorSet;
                }
                last = i;
            }
            if (mirrorSet != null) {
                mirrorSet.update();
                LinkedHashSet unique = new LinkedHashSet();
                CollectionUtils.addAll(unique, assigned);
                unique.remove(null);
                this.mirrorSets = unique.toArray(EMPTY_MIRROR_SETS);
            }
        }

        int size() {
            return this.mirrorSets.length;
        }

        MirrorSet get(int index) {
            return this.mirrorSets[index];
        }

        @Nullable
        MirrorSet getAssigned(int attributeIndex) {
            return this.assigned[attributeIndex];
        }

        int[] resolve(@Nullable Object source, @Nullable Object annotation, ValueExtractor valueExtractor) {
            int[] result = new int[AnnotationTypeMapping.this.methods.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = i;
            }
            for (MirrorSet mirrorSet : this.mirrorSets) {
                int resolved = mirrorSet.resolve(source, annotation, valueExtractor);
                for (int j = 0; j < mirrorSet.size; ++j) {
                    result[mirrorSet.indexes[j]] = resolved;
                }
            }
            return result;
        }

        final class MirrorSet {
            public int size;
            public final int[] indexes;

            MirrorSet() {
                this.indexes = new int[AnnotationTypeMapping.this.methods.size()];
            }

            void update() {
                this.size = 0;
                Arrays.fill(this.indexes, -1);
                MirrorSet[] assigned = MirrorSets.this.assigned;
                for (int i = 0; i < assigned.length; ++i) {
                    if (assigned[i] != this) continue;
                    this.indexes[this.size] = i;
                    ++this.size;
                }
            }

            <A> int resolve(@Nullable Object source, @Nullable A annotation, ValueExtractor valueExtractor) {
                int result = -1;
                Object lastValue = null;
                int[] indexes = this.indexes;
                Method[] attributes = AnnotationTypeMapping.this.methods.attributes;
                for (int i = 0; i < this.size; ++i) {
                    boolean isDefaultValue;
                    Method attribute = attributes[indexes[i]];
                    Object value = valueExtractor.extract(attribute, annotation);
                    boolean bl = isDefaultValue = value == null || AnnotationTypeMapping.isEquivalentToDefaultValue(attribute, value, valueExtractor);
                    if (isDefaultValue || ObjectUtils.nullSafeEquals(lastValue, value)) {
                        if (result != -1) continue;
                        result = indexes[i];
                        continue;
                    }
                    if (lastValue != null && !ObjectUtils.nullSafeEquals(lastValue, value)) {
                        Object on = source != null ? " declared on " + source : "";
                        throw new AnnotationConfigurationException(String.format("Different @AliasFor mirror values for annotation [%s]%s; attribute '%s' and its alias '%s' are declared with values of [%s] and [%s].", AnnotationTypeMapping.this.annotationType.getName(), on, attributes[result].getName(), attribute.getName(), ObjectUtils.nullSafeToString(lastValue), ObjectUtils.nullSafeToString(value)));
                    }
                    result = indexes[i];
                    lastValue = value;
                }
                return result;
            }

            Method get(int index) {
                int attributeIndex = this.indexes[index];
                return AnnotationTypeMapping.this.methods.get(attributeIndex);
            }

            int getAttributeIndex(int index) {
                return this.indexes[index];
            }
        }
    }
}

