/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.Property;
import cn.taketoday.util.AnnotationsAnnotatedElementAdapter;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class TypeDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashMap<Class<?>, TypeDescriptor> commonTypesCache = new HashMap(32);
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final AnnotatedElement annotatedElement;

    public TypeDescriptor(Field field) {
        this.resolvableType = ResolvableType.fromField(field);
        this.type = this.resolvableType.resolve(field.getType());
        this.annotatedElement = new TypeDescriptorAnnotatedElementAdapter(field.getAnnotations());
    }

    public TypeDescriptor(ResolvableType resolvableType, @Nullable Class<?> type, @Nullable Annotation[] annotations) {
        this.resolvableType = resolvableType;
        this.type = type != null ? type : resolvableType.toClass();
        this.annotatedElement = new TypeDescriptorAnnotatedElementAdapter(annotations);
    }

    public TypeDescriptor(ResolvableType resolvableType, @Nullable Class<?> type, AnnotatedElement annotated) {
        this.annotatedElement = annotated;
        this.resolvableType = resolvableType;
        this.type = type != null ? type : resolvableType.toClass();
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        this.resolvableType = ResolvableType.forMethodParameter(methodParameter);
        this.type = this.resolvableType.resolve(methodParameter.getNestedParameterType());
        this.annotatedElement = new TypeDescriptorAnnotatedElementAdapter(methodParameter.getParameterIndex() == -1 ? methodParameter.getMethodAnnotations() : methodParameter.getParameterAnnotations());
    }

    public TypeDescriptor(Property property) {
        Assert.notNull((Object)property, "Property must not be null");
        this.resolvableType = ResolvableType.forMethodParameter(property.getMethodParameter());
        this.type = this.resolvableType.resolve(property.getType());
        this.annotatedElement = new TypeDescriptorAnnotatedElementAdapter(property.getAnnotations());
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isCollection() {
        return CollectionUtils.isCollection(this.type);
    }

    public Class<?> getComponentType() {
        return this.type.getComponentType();
    }

    public boolean isInstance(Object source) {
        return this.type.isInstance(source);
    }

    public boolean is(Class<?> testClass) {
        return this.type == testClass;
    }

    public boolean isAssignableFrom(Class<?> subType) {
        return this.type.isAssignableFrom(subType);
    }

    public boolean isAssignableTo(Class<?> superType) {
        return superType.isAssignableFrom(this.type);
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public Object getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public String getSimpleName() {
        return this.type.getSimpleName();
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Object getSource() {
        return this.resolvableType.getSource();
    }

    public TypeDescriptor narrow(Object value) {
        if (value == null) {
            return this;
        }
        ResolvableType narrowed = ResolvableType.fromType(value.getClass(), this.getResolvableType());
        return new TypeDescriptor(narrowed, value.getClass(), this.getAnnotations());
    }

    @Nullable
    public TypeDescriptor upcast(Class<?> superType) {
        if (superType == null) {
            return null;
        }
        Assert.isAssignable(superType, this.getType());
        return new TypeDescriptor(this.getResolvableType().as(superType), superType, this.getAnnotations());
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public Annotation[] getAnnotations() {
        return this.annotatedElement.getAnnotations();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return AnnotatedElementUtils.hasAnnotation(this.annotatedElement, annotationType);
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return AnnotationUtils.findAnnotation(this.annotatedElement, annotationType);
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean typesAssignable = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!typesAssignable) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.isNestedAssignable(this.getElementDescriptor(), typeDescriptor.getElementDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementDescriptor(), typeDescriptor.getElementDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyDescriptor(), typeDescriptor.getMapKeyDescriptor()) && this.isNestedAssignable(this.getMapValueDescriptor(), typeDescriptor.getMapValueDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(TypeDescriptor nestedTypeDescriptor, TypeDescriptor otherNestedTypeDescriptor) {
        return nestedTypeDescriptor == null || otherNestedTypeDescriptor == null || nestedTypeDescriptor.isAssignableTo(otherNestedTypeDescriptor);
    }

    @Nullable
    public TypeDescriptor getElementDescriptor() {
        if (this.getResolvableType().isArray()) {
            return new TypeDescriptor(this.getResolvableType().getComponentType(), null, this.getAnnotations());
        }
        if (Stream.class.isAssignableFrom(this.getType())) {
            return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().as(Stream.class).getGeneric(0));
        }
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asCollection().getGeneric(0));
    }

    @Nullable
    public TypeDescriptor elementDescriptor(Object element) {
        return this.narrow(element, this.getElementDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Nullable
    public TypeDescriptor getMapKeyDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(0));
    }

    @Nullable
    public TypeDescriptor getMapKeyDescriptor(Object mapKey) {
        return this.narrow(mapKey, this.getMapKeyDescriptor());
    }

    @Nullable
    public TypeDescriptor getMapValueDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(1));
    }

    @Nullable
    public TypeDescriptor getMapValueDescriptor(Object mapValue) {
        return this.narrow(mapValue, this.getMapValueDescriptor());
    }

    @Nullable
    private TypeDescriptor narrow(Object value, TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(value);
        }
        if (value != null) {
            return this.narrow(value);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor otherDesc = (TypeDescriptor)other;
        if (this.getType() != otherDesc.getType()) {
            return false;
        }
        if (!this.annotationsMatch(otherDesc)) {
            return false;
        }
        if (this.isCollection() || this.isArray()) {
            return Objects.equals(this.getElementDescriptor(), otherDesc.getElementDescriptor());
        }
        if (this.isMap()) {
            return Objects.equals(this.getMapKeyDescriptor(), otherDesc.getMapKeyDescriptor()) && Objects.equals(this.getMapValueDescriptor(), otherDesc.getMapValueDescriptor());
        }
        return true;
    }

    private boolean annotationsMatch(TypeDescriptor otherDesc) {
        Annotation[] otherAnns;
        Annotation[] anns = this.getAnnotations();
        if (anns == (otherAnns = otherDesc.getAnnotations())) {
            return true;
        }
        if (anns.length != otherAnns.length) {
            return false;
        }
        if (anns.length > 0) {
            for (int i = 0; i < anns.length; ++i) {
                if (this.annotationEquals(anns[i], otherAnns[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean annotationEquals(Annotation ann, Annotation otherAnn) {
        return ann == otherAnn || ann.getClass() == otherAnn.getClass() && ann.equals(otherAnn);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.resolvableType, this.annotatedElement);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Annotation ann : this.getAnnotations()) {
            builder.append("@").append(ann.annotationType().getName()).append(' ');
        }
        builder.append(this.getResolvableType());
        return builder.toString();
    }

    @Nullable
    public static TypeDescriptor fromObject(@Nullable Object source) {
        return source != null ? TypeDescriptor.valueOf(source.getClass()) : null;
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        TypeDescriptor desc;
        if (type == null) {
            type = Object.class;
        }
        return (desc = commonTypesCache.get(type)) != null ? desc : new TypeDescriptor(ResolvableType.fromClass(type), null, (Annotation[])null);
    }

    public static TypeDescriptor collection(Class<?> collectionType, Class<?> element) {
        return TypeDescriptor.collection(collectionType, TypeDescriptor.valueOf(element));
    }

    public static TypeDescriptor collection(Class<?> collectionType, TypeDescriptor elementDescriptor) {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType element = elementDescriptor != null ? elementDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.fromClassWithGenerics(collectionType, element), null, (Annotation[])null);
    }

    public static TypeDescriptor map(Class<?> mapType, Class<?> key, Class<?> value) {
        return TypeDescriptor.map(mapType, TypeDescriptor.valueOf(key), TypeDescriptor.valueOf(value));
    }

    public static TypeDescriptor map(Class<?> mapType, TypeDescriptor keyDescriptor, TypeDescriptor valueDescriptor) {
        Assert.notNull(mapType, "Map type must not be null");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type must be a [java.util.Map]");
        }
        ResolvableType key = keyDescriptor != null ? keyDescriptor.resolvableType : null;
        ResolvableType value = valueDescriptor != null ? valueDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.fromClassWithGenerics(mapType, key, value), null, (Annotation[])null);
    }

    public static TypeDescriptor array(TypeDescriptor elementDescriptor) {
        if (elementDescriptor == null) {
            return null;
        }
        return new TypeDescriptor(ResolvableType.fromArrayComponent(elementDescriptor.resolvableType), null, elementDescriptor.getAnnotations());
    }

    public static TypeDescriptor nested(Field field, int nestingLevel) {
        return TypeDescriptor.nested(new TypeDescriptor(field), nestingLevel);
    }

    @Nullable
    public static TypeDescriptor nested(MethodParameter methodParameter, int nestingLevel) {
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("MethodParameter nesting level must be 1: use the nestingLevel parameter to specify the desired nestingLevel for nested type traversal");
        }
        return TypeDescriptor.nested(new TypeDescriptor(methodParameter), nestingLevel);
    }

    @Nullable
    public static TypeDescriptor nested(TypeDescriptor typeDescriptor, int nestingLevel) {
        ResolvableType nested = typeDescriptor.resolvableType;
        for (int i = 0; i < nestingLevel; ++i) {
            if (Object.class == nested.getType()) continue;
            nested = nested.getNested(2);
        }
        if (nested == ResolvableType.NONE) {
            return null;
        }
        return TypeDescriptor.getRelatedIfResolvable(typeDescriptor, nested);
    }

    @Nullable
    private static TypeDescriptor getRelatedIfResolvable(TypeDescriptor source, ResolvableType type) {
        if (type.resolve() == null) {
            return null;
        }
        return new TypeDescriptor(type, null, source.getAnnotations());
    }

    public static TypeDescriptor fromField(Field beanProperty) {
        return new TypeDescriptor(beanProperty);
    }

    public static TypeDescriptor forParameter(Executable executable, int parameterIndex) {
        Parameter parameter = ReflectionUtils.getParameter(executable, parameterIndex);
        return TypeDescriptor.fromParameter(parameter);
    }

    public static TypeDescriptor fromParameter(Parameter parameter) {
        ResolvableType resolvableType = ResolvableType.fromParameter(parameter);
        return new TypeDescriptor(resolvableType, parameter.getType(), parameter);
    }

    static {
        for (Class<?> preCachedClass : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(preCachedClass, TypeDescriptor.valueOf(preCachedClass));
        }
    }

    class TypeDescriptorAnnotatedElementAdapter
    extends AnnotationsAnnotatedElementAdapter {
        public TypeDescriptorAnnotatedElementAdapter(Annotation[] annotations) {
            super(annotations);
        }

        public String toString() {
            return TypeDescriptor.this.toString();
        }
    }
}

