/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.DefaultMultiValueMap;
import cn.taketoday.util.CollectionUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LinkedMultiValueMap<K, V>
extends DefaultMultiValueMap<K, V> {
    private static final long serialVersionUID = 1L;

    public LinkedMultiValueMap() {
        super(new LinkedHashMap());
    }

    public LinkedMultiValueMap(int expectedSize) {
        super(CollectionUtils.newLinkedHashMap(expectedSize));
    }

    public LinkedMultiValueMap(Map<K, List<V>> otherMap) {
        super(new LinkedHashMap<K, List<V>>(otherMap));
    }

    @Override
    public LinkedMultiValueMap<K, V> deepCopy() {
        LinkedMultiValueMap copy = new LinkedMultiValueMap(this.size());
        this.forEach((key, values) -> copy.put((Object)key, new ArrayList(values)));
        return copy;
    }

    @Override
    public LinkedMultiValueMap<K, V> clone() {
        return new LinkedMultiValueMap<K, V>(this);
    }
}

