/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.reflect;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.ProcessArrayCallback;
import cn.taketoday.lang.Constant;
import cn.taketoday.util.ReflectionUtils;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;

public abstract class MulticastDelegate
implements Cloneable {
    protected Object[] targets = Constant.EMPTY_OBJECTS;

    protected MulticastDelegate() {
    }

    public List<Object> getTargets() {
        return Arrays.asList(this.targets);
    }

    public abstract MulticastDelegate add(Object var1);

    protected MulticastDelegate addHelper(Object target) {
        MulticastDelegate copy = this.newInstance();
        Object[] targets = this.targets;
        copy.targets = new Object[targets.length + 1];
        System.arraycopy(targets, 0, copy.targets, 0, targets.length);
        copy.targets[targets.length] = target;
        return copy;
    }

    public MulticastDelegate remove(Object target) {
        Object[] targets = this.targets;
        for (int i = targets.length - 1; i >= 0; --i) {
            if (!targets[i].equals(target)) continue;
            MulticastDelegate copy = this.newInstance();
            copy.targets = new Object[targets.length - 1];
            System.arraycopy(targets, 0, copy.targets, 0, i);
            System.arraycopy(targets, i + 1, copy.targets, i, targets.length - i - 1);
            return copy;
        }
        return this;
    }

    public abstract MulticastDelegate newInstance();

    public static MulticastDelegate create(Class<?> iface) {
        return new Generator().setInterface(iface).create();
    }

    public static class Generator
    extends AbstractClassGenerator<Object> {
        static final Type MULTICAST_DELEGATE = Type.fromClass(MulticastDelegate.class);
        static final MethodSignature ADD_DELEGATE = new MethodSignature(MULTICAST_DELEGATE, "add", Type.TYPE_OBJECT);
        static final MethodSignature ADD_HELPER = new MethodSignature(MULTICAST_DELEGATE, "addHelper", Type.TYPE_OBJECT);
        static final MethodSignature NEW_INSTANCE = new MethodSignature(MULTICAST_DELEGATE, "newInstance", Type.EMPTY_ARRAY);
        private Class<?> iface;

        public Generator() {
            super(MulticastDelegate.class);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.iface.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.iface);
        }

        public Generator setInterface(Class<?> iface) {
            this.iface = iface;
            this.setNeighbor(iface);
            return this;
        }

        public MulticastDelegate create() {
            this.setNamePrefix(MulticastDelegate.class.getName());
            return (MulticastDelegate)super.create(this.iface.getName());
        }

        @Override
        public void generateClass(ClassVisitor cv) {
            MethodInfo method = MethodInfo.from(ReflectionUtils.findFunctionalInterfaceMethod(this.iface));
            ClassEmitter ce = new ClassEmitter(cv);
            ce.beginClass(52, 1, this.getClassName(), MULTICAST_DELEGATE, Type.array(Type.fromClass(this.iface)), "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            this.emitProxy(ce, method);
            CodeEmitter e = ce.beginMethod(1, NEW_INSTANCE, new Type[0]);
            e.new_instance_this();
            e.dup();
            e.invoke_constructor_this();
            e.returnValue();
            e.end_method();
            e = ce.beginMethod(1, ADD_DELEGATE, new Type[0]);
            e.loadThis();
            e.loadArg(0);
            e.checkCast(Type.fromClass(this.iface));
            e.invoke_virtual_this(ADD_HELPER);
            e.returnValue();
            e.end_method();
            ce.endClass();
        }

        private void emitProxy(ClassEmitter ce, final MethodInfo method) {
            int modifiers = 1;
            if ((method.getModifiers() & 0x80) == 128) {
                modifiers |= 0x80;
            }
            final CodeEmitter e = EmitUtils.beginMethod(ce, method, modifiers);
            Type returnType = method.getSignature().getReturnType();
            final boolean returns = returnType != Type.VOID_TYPE;
            Local result = null;
            if (returns) {
                result = e.newLocal(returnType);
                e.zero_or_null(returnType);
                e.storeLocal(result);
            }
            e.loadThis();
            e.super_getfield("targets", Type.TYPE_OBJECT_ARRAY);
            final Local result2 = result;
            EmitUtils.processArray(e, Type.TYPE_OBJECT_ARRAY, new ProcessArrayCallback(){

                @Override
                public void processElement(Type type) {
                    e.checkCast(Type.fromClass(iface));
                    e.loadArgs();
                    e.invoke(method);
                    if (returns) {
                        e.storeLocal(result2);
                    }
                }
            });
            if (returns) {
                e.loadLocal(result);
            }
            e.returnValue();
            e.end_method();
        }

        @Override
        protected Object firstInstance(Class<Object> type) {
            return ((MulticastDelegate)ReflectionUtils.newInstance(type)).newInstance();
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((MulticastDelegate)instance).newInstance();
        }
    }
}

