/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.ClassEmitter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class InterfaceMaker
extends AbstractClassGenerator<Object> {
    private final HashMap<MethodSignature, Type[]> signatures = new HashMap();

    public InterfaceMaker() {
        super(InterfaceMaker.class);
    }

    public void add(MethodSignature sig, Type[] exceptions) {
        this.signatures.put(sig, exceptions);
    }

    public void add(Method method) {
        this.add(MethodSignature.from(method), Type.getExceptionTypes(method));
    }

    public void add(Class<?> clazz) {
        for (Method m : clazz.getMethods()) {
            if (m.getDeclaringClass().getName().equals("java.lang.Object")) continue;
            this.add(m);
        }
    }

    public Class<?> create() {
        this.setUseCache(false);
        return (Class)super.create(this);
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        return null;
    }

    @Override
    protected Object firstInstance(Class<Object> type) throws Exception {
        return type;
    }

    @Override
    protected Object nextInstance(Object instance) {
        throw new IllegalStateException("InterfaceMaker does not cache");
    }

    @Override
    public void generateClass(ClassVisitor v) throws Exception {
        ClassEmitter ce = new ClassEmitter(v);
        ce.beginClass(52, 1537, this.getClassName(), (Type)null, (Type[])null, "<cglibGenerated>");
        int access = 1025;
        for (Map.Entry<MethodSignature, Type[]> entry : this.signatures.entrySet()) {
            ce.beginMethod(1025, entry.getKey(), entry.getValue()).end_method();
        }
        ce.endClass();
    }
}

