/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.ClassReader;
import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.commons.TableSwitchGenerator;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.core.DuplicatesPredicate;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.MethodInfoTransformer;
import cn.taketoday.bytecode.core.MethodWrapper;
import cn.taketoday.bytecode.core.ObjectSwitchCallback;
import cn.taketoday.bytecode.core.RejectModifierPredicate;
import cn.taketoday.bytecode.core.VisibilityPredicate;
import cn.taketoday.bytecode.core.WeakCacheKey;
import cn.taketoday.bytecode.proxy.Callback;
import cn.taketoday.bytecode.proxy.CallbackFilter;
import cn.taketoday.bytecode.proxy.CallbackGenerator;
import cn.taketoday.bytecode.proxy.CallbackInfo;
import cn.taketoday.bytecode.proxy.Factory;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Enhancer
extends AbstractClassGenerator<Object> {
    private static final CallbackFilter ALL_ZERO = m -> 0;
    private static final String BOUND_FIELD = "today$Bound";
    private static final String CONSTRUCTED_FIELD = "today$Constructed";
    private static final String FACTORY_DATA_FIELD = "today$FactoryData";
    private static final String THREAD_CALLBACKS_FIELD = "today$ThreadCallbacks";
    private static final String STATIC_CALLBACKS_FIELD = "today$StaticCallbacks";
    private static final String SET_THREAD_CALLBACKS_NAME = "today$SetThreadCallbacks";
    private static final String SET_STATIC_CALLBACKS_NAME = "today$SetStaticCallbacks";
    private static final String CALLBACK_FILTER_FIELD = "today$CallbackFilter";
    private static final Type OBJECT_TYPE = Type.TYPE_OBJECT;
    private static final Type FACTORY = Type.fromClass(Factory.class);
    private static final Type CALLBACK = Type.fromClass(Callback.class);
    private static final Type CALLBACK_ARRAY = Type.fromClass(Callback[].class);
    private static final Type THREAD_LOCAL = Type.fromInternalName("java/lang/ThreadLocal");
    private static final Type ILLEGAL_STATE_EXCEPTION = Type.fromInternalName("java/lang/IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = Type.fromInternalName("java/lang/IllegalArgumentException");
    static final MethodSignature NEW_INSTANCE = new MethodSignature(Type.TYPE_OBJECT, "newInstance", CALLBACK_ARRAY);
    static final MethodSignature SET_THREAD_CALLBACKS = new MethodSignature(Type.VOID_TYPE, "today$SetThreadCallbacks", CALLBACK_ARRAY);
    static final MethodSignature SET_STATIC_CALLBACKS = new MethodSignature(Type.VOID_TYPE, "today$SetStaticCallbacks", CALLBACK_ARRAY);
    static final MethodSignature MULTIARG_NEW_INSTANCE = new MethodSignature(Type.TYPE_OBJECT, "newInstance", Type.TYPE_CLASS_ARRAY, Type.TYPE_OBJECT_ARRAY, CALLBACK_ARRAY);
    static final MethodSignature GET_CALLBACKS = new MethodSignature(CALLBACK_ARRAY, "getCallbacks", new Type[0]);
    static final MethodSignature GET_CALLBACK = new MethodSignature(CALLBACK, "getCallback", Type.INT_TYPE);
    static final MethodSignature SET_CALLBACKS = new MethodSignature(Type.VOID_TYPE, "setCallbacks", CALLBACK_ARRAY);
    static final MethodSignature SET_CALLBACK = new MethodSignature(Type.VOID_TYPE, "setCallback", Type.INT_TYPE, CALLBACK);
    static final MethodSignature SINGLE_NEW_INSTANCE = new MethodSignature(Type.TYPE_OBJECT, "newInstance", CALLBACK);
    static final MethodSignature THREAD_LOCAL_GET = MethodSignature.from("Object get()");
    static final MethodSignature THREAD_LOCAL_SET = MethodSignature.from("void set(Object)");
    static final MethodSignature BIND_CALLBACKS = MethodSignature.from("void today$BindCallbacks(Object)");
    private EnhancerFactoryData currentData;
    private Object currentKey;
    private Class<?>[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private Type[] callbackTypes;
    private boolean validateCallbackTypes;
    private boolean classOnly;
    private Class<?> superclass;
    private Class<?>[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private Long serialVersionUID;
    private boolean interceptDuringConstruction = true;

    public Enhancer() {
        super("Enhance");
    }

    public void setSuperclass(Class<?> superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(superclass);
            this.setNeighbor(superclass);
        } else if (superclass != null && superclass.equals(Object.class)) {
            this.superclass = null;
            this.setNeighbor(null);
        } else {
            this.setNeighbor(superclass);
            this.superclass = superclass;
        }
    }

    public void setInterfaces(Class<?> ... interfaces) {
        this.interfaces = interfaces;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(callback);
    }

    public void setCallbacks(Callback ... callbacks) {
        if (ObjectUtils.isEmpty(callbacks)) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
    }

    public void setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
    }

    public void setInterceptDuringConstruction(boolean interceptDuringConstruction) {
        this.interceptDuringConstruction = interceptDuringConstruction;
    }

    public void setCallbackType(Class<?> callbackType) {
        this.setCallbackTypes(callbackType);
    }

    public void setCallbackTypes(Class<?> ... callbackTypes) {
        if (ObjectUtils.isEmpty(callbackTypes)) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes(callbackTypes);
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class<?>[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
        return this.createHelper();
    }

    public Class<?> createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    public void setSerialVersionUID(Long sUID) {
        this.serialVersionUID = sUID;
    }

    private void preValidate() {
        if (this.callbackTypes == null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks, false);
            this.validateCallbackTypes = true;
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = ALL_ZERO;
        }
    }

    private void validate() {
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if (this.classOnly && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.validateCallbackTypes) {
            this.callbackTypes = null;
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            Type[] check = CallbackInfo.determineTypes(this.callbacks);
            for (int i = 0; i < check.length; ++i) {
                if (check[i].equals(this.callbackTypes[i])) continue;
                throw new IllegalStateException("Callback " + check[i] + " is not assignable to " + this.callbackTypes[i]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks);
        }
        if (this.interfaces != null) {
            for (Class<?> anInterface : this.interfaces) {
                if (anInterface == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (anInterface.isInterface()) continue;
                throw new IllegalStateException(anInterface + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        this.preValidate();
        String[] interfaces = CglibReflectUtils.getNames(this.interfaces);
        EnhancerKey key = new EnhancerKey(this.superclass != null ? this.superclass.getName() : null, interfaces != null ? Arrays.asList(interfaces) : null, this.filter == ALL_ZERO ? null : new WeakCacheKey<CallbackFilter>(this.filter), Arrays.asList(this.callbackTypes), this.useFactory, this.interceptDuringConstruction, this.serialVersionUID);
        this.currentKey = key;
        return super.create(key);
    }

    @Override
    protected Class<?> generate(AbstractClassGenerator.ClassLoaderData data) {
        this.validate();
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[CglibReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        return super.generate(data);
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (ObjectUtils.isNotEmpty(this.interfaces)) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        if (this.superclass != null) {
            return ReflectionUtils.getProtectionDomain(this.superclass);
        }
        if (ObjectUtils.isNotEmpty(this.interfaces)) {
            return ReflectionUtils.getProtectionDomain(this.interfaces[0]);
        }
        return null;
    }

    private MethodSignature rename(MethodSignature sig, int index) {
        return new MethodSignature("today$" + sig.getName() + "$" + index, sig.getDescriptor());
    }

    public static void getMethods(Class<?> superclass, Class<?>[] interfaces, List<Method> methods) {
        Enhancer.getMethods(superclass, interfaces, methods, null);
    }

    private static void getMethods(Class<?> superclass, @Nullable Class<?>[] interfaces, List<Method> methods, @Nullable List<Method> interfaceMethods) {
        MethodInfo.addAllMethods(superclass, methods);
        List<Method> target = methods;
        if (interfaceMethods != null) {
            target = interfaceMethods;
        }
        if (interfaces != null) {
            for (Class<?> anInterface : interfaces) {
                if (anInterface == Factory.class) continue;
                CollectionUtils.addAll(target, (Object[])anInterface.getMethods());
            }
        }
        if (interfaceMethods != null) {
            methods.addAll(interfaceMethods);
        }
        CollectionUtils.filter(methods, new RejectModifierPredicate(8).and(new VisibilityPredicate(superclass, true)).and(new DuplicatesPredicate(methods)).and(new RejectModifierPredicate(16)));
    }

    @Override
    public void generateClass(ClassVisitor v) throws Exception {
        Class<Object> superclass = this.superclass;
        if (superclass == null) {
            superclass = Object.class;
        } else if (Modifier.isFinal(superclass.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + superclass.getName());
        }
        ArrayList<Constructor> constructors = new ArrayList<Constructor>(4);
        Collections.addAll(constructors, superclass.getDeclaredConstructors());
        this.filterConstructors(superclass, constructors);
        ArrayList<Method> actualMethods = new ArrayList<Method>();
        ArrayList<Method> interfaceMethods = new ArrayList<Method>();
        Enhancer.getMethods(superclass, this.interfaces, actualMethods, interfaceMethods);
        HashSet<Object> forcePublic = MethodWrapper.createSet(interfaceMethods);
        List<MethodInfo> methods = CollectionUtils.transform(actualMethods, method -> {
            int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
            if (forcePublic.contains(MethodWrapper.create(method))) {
                modifiers = modifiers & 0xFFFFFFFB | 1;
            }
            return MethodInfo.from(method, modifiers);
        });
        ClassEmitter e = new ClassEmitter(v);
        if (this.currentData == null) {
            e.beginClass(52, 1, this.getClassName(), Type.fromClass(superclass), this.useFactory ? Type.add(Type.getTypes(this.interfaces), FACTORY) : Type.getTypes(this.interfaces), "<cglibGenerated>");
        } else {
            e.beginClass(52, 1, this.getClassName(), null, Type.array(FACTORY), "<cglibGenerated>");
        }
        List<MethodInfo> constructorInfo = CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        e.declare_field(2, BOUND_FIELD, Type.BOOLEAN_TYPE, null);
        e.declare_field(9, FACTORY_DATA_FIELD, OBJECT_TYPE, null);
        if (!this.interceptDuringConstruction) {
            e.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null);
        }
        e.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null);
        e.declare_field(26, STATIC_CALLBACKS_FIELD, CALLBACK_ARRAY, null);
        if (this.serialVersionUID != null) {
            e.declare_field(26, "serialVersionUID", Type.LONG_TYPE, this.serialVersionUID);
        }
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.declare_field(2, Enhancer.getCallbackField(i), this.callbackTypes[i], null);
        }
        e.declare_field(10, CALLBACK_FILTER_FIELD, OBJECT_TYPE, null);
        if (this.currentData == null) {
            this.emitMethods(e, methods, actualMethods);
            this.emitConstructors(e, constructorInfo);
        } else {
            this.emitDefaultConstructor(e);
        }
        this.emitSetThreadCallbacks(e);
        this.emitSetStaticCallbacks(e);
        this.emitBindCallbacks(e);
        if (this.useFactory || this.currentData != null) {
            int[] keys = this.getCallbackKeys();
            this.emitNewInstanceCallbacks(e);
            this.emitNewInstanceCallback(e);
            this.emitNewInstanceMultiarg(e, constructorInfo);
            this.emitGetCallback(e, keys);
            this.emitSetCallback(e, keys);
            this.emitGetCallbacks(e);
            this.emitSetCallbacks(e);
        }
        e.endClass();
    }

    protected void filterConstructors(Class<?> superclass, List<Constructor> constructors) {
        CollectionUtils.filter(constructors, new VisibilityPredicate(superclass, true));
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException("No visible constructors in " + superclass);
        }
    }

    @Override
    protected Object firstInstance(Class type) throws Exception {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    @Override
    protected Object nextInstance(Object instance) {
        EnhancerFactoryData data = (EnhancerFactoryData)instance;
        if (this.classOnly) {
            return data.generatedClass;
        }
        Class<?>[] argumentTypes = this.argumentTypes;
        Object[] arguments = this.arguments;
        if (argumentTypes == null) {
            argumentTypes = Constant.EMPTY_CLASSES;
            arguments = null;
        }
        return data.newInstance(argumentTypes, arguments, this.callbacks);
    }

    @Override
    protected Object wrapCachedClass(Class klass) {
        Class<?>[] argumentTypes = this.argumentTypes;
        if (argumentTypes == null) {
            argumentTypes = Constant.EMPTY_CLASSES;
        }
        EnhancerFactoryData factoryData = new EnhancerFactoryData(klass, argumentTypes, this.classOnly);
        try {
            Field factoryDataField = klass.getField(FACTORY_DATA_FIELD);
            factoryDataField.set(null, factoryData);
            Field callbackFilterField = klass.getDeclaredField(CALLBACK_FILTER_FIELD);
            callbackFilterField.setAccessible(true);
            callbackFilterField.set(null, this.filter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CodeGenerationException(e);
        }
        return new WeakReference<EnhancerFactoryData>(factoryData);
    }

    @Override
    protected Object unwrapCachedValue(Object cached) {
        if (this.currentKey instanceof EnhancerKey) {
            return ((WeakReference)cached).get();
        }
        return super.unwrapCachedValue(cached);
    }

    public static void registerCallbacks(Class generatedClass, Callback[] callbacks) {
        Enhancer.setThreadCallbacks(generatedClass, callbacks);
    }

    public static void registerStaticCallbacks(Class generatedClass, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(generatedClass, callbacks, SET_STATIC_CALLBACKS_NAME);
    }

    public static boolean isEnhanced(Class type) {
        return Enhancer.getCallbacksSetter(type, SET_THREAD_CALLBACKS_NAME) != null;
    }

    private static void setThreadCallbacks(Class type, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(type, callbacks, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class type, Callback[] callbacks, String methodName) {
        try {
            Method callbacksSetter = Enhancer.getCallbacksSetter(type, methodName);
            if (callbacksSetter == null) {
                throw new IllegalArgumentException(type + " is not an enhanced class");
            }
            callbacksSetter.invoke(null, new Object[]{callbacks});
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
    }

    private static Method getCallbacksSetter(Class type, String methodName) {
        try {
            return type.getDeclaredMethod(methodName, Callback[].class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Object createUsingReflection(Class type) {
        Enhancer.setThreadCallbacks(type, this.callbacks);
        try {
            if (this.argumentTypes != null) {
                Object t = ReflectionUtils.newInstance(type, this.argumentTypes, this.arguments);
                return t;
            }
            Object t = ReflectionUtils.newInstance(type);
            return t;
        }
        finally {
            Enhancer.setThreadCallbacks(type, null);
        }
    }

    public static Object create(Class type, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(type);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, Callback callback) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallback(callback);
        return e.create();
    }

    public static Object create(Class superclass, Class[] interfaces, CallbackFilter filter, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setSuperclass(superclass);
        e.setInterfaces(interfaces);
        e.setCallbackFilter(filter);
        e.setCallbacks(callbacks);
        return e.create();
    }

    private void emitDefaultConstructor(ClassEmitter ce) {
        Constructor declaredConstructor;
        try {
            declaredConstructor = Object.class.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Object should have default constructor ", e);
        }
        MethodInfo constructor = MethodInfo.from(declaredConstructor);
        CodeEmitter e = EmitUtils.beginMethod(ce, constructor, 1);
        e.loadThis();
        e.dup();
        MethodSignature sig = constructor.getSignature();
        e.super_invoke_constructor(sig);
        e.returnValue();
        e.end_method();
    }

    private void emitConstructors(ClassEmitter ce, List<MethodInfo> constructors) {
        boolean seenNull = false;
        String descriptor = MethodSignature.EMPTY_CONSTRUCTOR.getDescriptor();
        for (MethodInfo constructor : constructors) {
            if (this.currentData != null && !descriptor.equals(constructor.getSignature().getDescriptor())) continue;
            CodeEmitter e = EmitUtils.beginMethod(ce, constructor, 1);
            e.loadThis();
            e.dup();
            e.loadArgs();
            MethodSignature sig = constructor.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals(descriptor);
            e.super_invoke_constructor(sig);
            if (this.currentData == null) {
                e.invoke_static_this(BIND_CALLBACKS);
                if (!this.interceptDuringConstruction) {
                    e.loadThis();
                    e.push(1);
                    e.putField(CONSTRUCTED_FIELD);
                }
            }
            e.returnValue();
            e.end_method();
        }
        if (!this.classOnly && !seenNull && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        Type[] types = this.callbackTypes;
        int[] keys = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            keys[i] = i;
        }
        return keys;
    }

    private void emitGetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.beginMethod(1, GET_CALLBACK, new Type[0]);
        e.loadThis();
        e.invoke_static_this(BIND_CALLBACKS);
        e.loadThis();
        e.loadArg(0);
        e.tableSwitch(keys, new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label end) {
                e.getField(Enhancer.getCallbackField(key));
                e.goTo(end);
            }

            @Override
            public void generateDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.returnValue();
        e.end_method();
    }

    private void emitSetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.beginMethod(1, SET_CALLBACK, new Type[0]);
        e.loadArg(0);
        e.tableSwitch(keys, new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label end) {
                e.loadThis();
                e.loadArg(1);
                e.checkCast(Enhancer.this.callbackTypes[key]);
                e.putField(Enhancer.getCallbackField(key));
                e.goTo(end);
            }

            @Override
            public void generateDefault() {
            }
        });
        e.returnValue();
        e.end_method();
    }

    private void emitSetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, SET_CALLBACKS, new Type[0]);
        e.loadThis();
        e.loadArg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup2();
            e.aaload(i);
            e.checkCast(this.callbackTypes[i]);
            e.putField(Enhancer.getCallbackField(i));
        }
        e.returnValue();
        e.end_method();
    }

    private void emitGetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, GET_CALLBACKS, new Type[0]);
        e.loadThis();
        e.invoke_static_this(BIND_CALLBACKS);
        e.loadThis();
        e.push(this.callbackTypes.length);
        e.newArray(CALLBACK);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup();
            e.push(i);
            e.loadThis();
            e.getField(Enhancer.getCallbackField(i));
            e.aastore();
        }
        e.returnValue();
        e.end_method();
    }

    private void emitNewInstanceCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, NEW_INSTANCE, new Type[0]);
        Type thisType = this.getThisType(e);
        e.loadArg(0);
        e.invokeStatic(thisType, SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(e);
    }

    private Type getThisType(CodeEmitter e) {
        if (this.currentData == null) {
            return e.getClassEmitter().getClassType();
        }
        return Type.fromClass(this.currentData.generatedClass);
    }

    private void emitCommonNewInstance(CodeEmitter e) {
        Type thisType = this.getThisType(e);
        e.newInstance(thisType);
        e.dup();
        e.invokeConstructor(thisType);
        e.aconst_null();
        e.invokeStatic(thisType, SET_THREAD_CALLBACKS);
        e.returnValue();
        e.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, SINGLE_NEW_INSTANCE, new Type[0]);
        if (this.callbackTypes.length == 1) {
            e.push(1);
            e.newArray(CALLBACK);
            e.dup();
            e.push(0);
            e.loadArg(0);
            e.aastore();
            e.invokeStatic(this.getThisType(e), SET_THREAD_CALLBACKS);
        } else if (this.callbackTypes.length != 0) {
            e.throwException(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
        }
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceMultiarg(ClassEmitter ce, List constructors) {
        final CodeEmitter e = ce.beginMethod(1, MULTIARG_NEW_INSTANCE, new Type[0]);
        final Type thisType = this.getThisType(e);
        e.loadArg(2);
        e.invokeStatic(thisType, SET_THREAD_CALLBACKS);
        e.newInstance(thisType);
        e.dup();
        e.loadArg(0);
        EmitUtils.constructorSwitch(e, constructors, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                MethodInfo constructor = (MethodInfo)key;
                Type[] types = constructor.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e.loadArg(1);
                    e.push(i);
                    e.aaload();
                    e.unbox(types[i]);
                }
                e.invokeConstructor(thisType, constructor.getSignature());
                e.goTo(end);
            }

            @Override
            public void processDefault() {
                e.throwException(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.aconst_null();
        e.invokeStatic(thisType, SET_THREAD_CALLBACKS);
        e.returnValue();
        e.end_method();
    }

    private void emitMethods(ClassEmitter ce, List<MethodInfo> methods, List<Method> actualMethods) {
        CallbackGenerator[] generators = CallbackInfo.getGenerators(this.callbackTypes);
        final HashMap<MethodInfo, Integer> indexes = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> originalModifiers = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> positions = Enhancer.getIndexMap(methods);
        final HashMap declToBridge = new HashMap();
        HashMap<CallbackGenerator, ArrayList<MethodInfo>> groups = new HashMap<CallbackGenerator, ArrayList<MethodInfo>>();
        Iterator<Method> it2 = actualMethods != null ? actualMethods.iterator() : null;
        for (MethodInfo method : methods) {
            Method actualMethod = it2 != null ? it2.next() : null;
            int index = this.filter.accept(actualMethod);
            if (index >= this.callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            originalModifiers.put(method, actualMethod != null ? actualMethod.getModifiers() : method.getModifiers());
            indexes.put(method, index);
            ArrayList<MethodInfo> group = (ArrayList<MethodInfo>)groups.get(generators[index]);
            if (group == null) {
                group = new ArrayList<MethodInfo>(methods.size());
                groups.put(generators[index], group);
            }
            group.add(method);
            if (actualMethod == null || !actualMethod.isBridge()) continue;
            HashSet<MethodSignature> bridges = (HashSet<MethodSignature>)declToBridge.get(actualMethod.getDeclaringClass());
            if (bridges == null) {
                bridges = new HashSet<MethodSignature>();
                declToBridge.put(actualMethod.getDeclaringClass(), bridges);
            }
            bridges.add(method.getSignature());
        }
        HashSet<CallbackGenerator> seenGen = new HashSet<CallbackGenerator>();
        CodeEmitter se = ce.getStaticHook();
        se.newInstance(THREAD_LOCAL);
        se.dup();
        se.invokeConstructor(THREAD_LOCAL, MethodSignature.EMPTY_CONSTRUCTOR);
        se.putField(THREAD_CALLBACKS_FIELD);
        CallbackGenerator.Context context = new CallbackGenerator.Context(){
            Map<MethodSignature, MethodSignature> bridgeToTarget = null;

            @Override
            public ClassLoader getClassLoader() {
                return Enhancer.this.getClassLoader();
            }

            @Override
            public int getOriginalModifiers(MethodInfo method) {
                return (Integer)originalModifiers.get(method);
            }

            @Override
            public int getIndex(MethodInfo method) {
                return (Integer)indexes.get(method);
            }

            @Override
            public void emitCallback(CodeEmitter e, int index) {
                Enhancer.this.emitCurrentCallback(e, index);
            }

            @Override
            public MethodSignature getImplSignature(MethodInfo method) {
                return Enhancer.this.rename(method.getSignature(), (Integer)positions.get(method));
            }

            @Override
            public void emitLoadArgsAndInvoke(CodeEmitter e, MethodInfo method) {
                MethodSignature bridgeTarget;
                if (this.bridgeToTarget == null) {
                    this.bridgeToTarget = BridgeMethodResolver.resolve(declToBridge);
                }
                if ((bridgeTarget = this.bridgeToTarget.get(method.getSignature())) != null) {
                    Type[] argumentTypes = bridgeTarget.getArgumentTypes();
                    for (int i = 0; i < argumentTypes.length; ++i) {
                        e.loadArg(i);
                        Type target = argumentTypes[i];
                        if (target.equals(method.getSignature().getArgumentTypes()[i])) continue;
                        e.checkCast(target);
                    }
                    e.invoke_virtual_this(bridgeTarget);
                    Type retType = method.getSignature().getReturnType();
                    if (!retType.equals(bridgeTarget.getReturnType())) {
                        e.checkCast(retType);
                    }
                } else {
                    e.loadArgs();
                    e.super_invoke(method.getSignature());
                }
            }

            @Override
            public CodeEmitter beginMethod(ClassEmitter ce, MethodInfo method) {
                CodeEmitter e = EmitUtils.beginMethod(ce, method);
                if (!Enhancer.this.interceptDuringConstruction && !Modifier.isAbstract(method.getModifiers())) {
                    Label constructed = e.newLabel();
                    e.loadThis();
                    e.getField(Enhancer.CONSTRUCTED_FIELD);
                    e.ifJump(154, constructed);
                    e.loadThis();
                    e.loadArgs();
                    e.super_invoke();
                    e.returnValue();
                    e.mark(constructed);
                }
                return e;
            }
        };
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            CallbackGenerator gen = generators[i];
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            List fmethods = (List)groups.get(gen);
            if (fmethods == null) continue;
            try {
                gen.generate(ce, context, fmethods);
                gen.generateStatic(se, context, fmethods);
                continue;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new CodeGenerationException(x);
            }
        }
        se.returnValue();
        se.end_method();
    }

    static <T> HashMap<T, Integer> getIndexMap(List<T> list) {
        HashMap<T, Integer> indexes = new HashMap<T, Integer>(list.size());
        int index = 0;
        for (T obj : list) {
            indexes.put(obj, index++);
        }
        return indexes;
    }

    private void emitSetThreadCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(9, SET_THREAD_CALLBACKS, new Type[0]);
        e.getField(THREAD_CALLBACKS_FIELD);
        e.loadArg(0);
        e.invokeVirtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e.returnValue();
        e.end_method();
    }

    private void emitSetStaticCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(9, SET_STATIC_CALLBACKS, new Type[0]);
        e.loadArg(0);
        e.putField(STATIC_CALLBACKS_FIELD);
        e.returnValue();
        e.end_method();
    }

    private void emitCurrentCallback(CodeEmitter e, int index) {
        e.loadThis();
        e.getField(Enhancer.getCallbackField(index));
        e.dup();
        Label end = e.newLabel();
        e.ifNonNull(end);
        e.pop();
        e.loadThis();
        e.invoke_static_this(BIND_CALLBACKS);
        e.loadThis();
        e.getField(Enhancer.getCallbackField(index));
        e.mark(end);
    }

    private void emitBindCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(26, BIND_CALLBACKS, new Type[0]);
        Local me = e.newLocal();
        e.loadArg(0);
        e.checkcast_this();
        e.storeLocal(me);
        Label end = e.newLabel();
        e.loadLocal(me);
        e.getField(BOUND_FIELD);
        e.ifJump(154, end);
        e.loadLocal(me);
        e.push(1);
        e.putField(BOUND_FIELD);
        e.getField(THREAD_CALLBACKS_FIELD);
        e.invokeVirtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.dup();
        Label found_callback = e.newLabel();
        e.ifNonNull(found_callback);
        e.pop();
        e.getField(STATIC_CALLBACKS_FIELD);
        e.dup();
        e.ifNonNull(found_callback);
        e.pop();
        e.goTo(end);
        e.mark(found_callback);
        e.checkCast(CALLBACK_ARRAY);
        e.loadLocal(me);
        e.swap();
        for (int i = this.callbackTypes.length - 1; i >= 0; --i) {
            if (i != 0) {
                e.dup2();
            }
            e.aaload(i);
            e.checkCast(this.callbackTypes[i]);
            e.putField(Enhancer.getCallbackField(i));
        }
        e.mark(end);
        e.returnValue();
        e.end_method();
    }

    private static String getCallbackField(int index) {
        return "today$Callback_" + index;
    }

    private record EnhancerKey(@Nullable String type, @Nullable List<String> interfaces, @Nullable WeakCacheKey<CallbackFilter> filter, List<Type> callbackTypes, boolean useFactory, boolean interceptDuringConstruction, Long serialVersionUID) {
    }

    static class EnhancerFactoryData {
        public final Class<?> generatedClass;
        private final Method setThreadCallbacks;
        private final Class<?>[] primaryConstructorArgTypes;
        private final Constructor<?> primaryConstructor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object newInstance(Class<?>[] argumentTypes, Object[] arguments, Callback[] callbacks) {
            this.setThreadCallbacks(callbacks);
            try {
                if (this.primaryConstructorArgTypes == argumentTypes || Arrays.equals(this.primaryConstructorArgTypes, argumentTypes)) {
                    Object obj = ReflectionUtils.invokeConstructor(this.primaryConstructor, arguments);
                    return obj;
                }
                Object obj = ReflectionUtils.newInstance(this.generatedClass, argumentTypes, arguments);
                return obj;
            }
            finally {
                this.setThreadCallbacks(null);
            }
        }

        public EnhancerFactoryData(Class<?> generatedClass, Class<?>[] primaryConstructorArgTypes, boolean classOnly) {
            this.generatedClass = generatedClass;
            Method callbacksSetter = Enhancer.getCallbacksSetter(generatedClass, Enhancer.SET_THREAD_CALLBACKS_NAME);
            if (callbacksSetter == null) {
                throw new CodeGenerationException("today$SetThreadCallbacks Not found in class: " + generatedClass);
            }
            this.setThreadCallbacks = callbacksSetter;
            if (classOnly) {
                this.primaryConstructorArgTypes = null;
                this.primaryConstructor = null;
            } else {
                this.primaryConstructorArgTypes = primaryConstructorArgTypes;
                this.primaryConstructor = ReflectionUtils.getConstructor(generatedClass, primaryConstructorArgTypes);
            }
        }

        private void setThreadCallbacks(Callback[] callbacks) {
            try {
                this.setThreadCallbacks.invoke(this.generatedClass, new Object[]{callbacks});
            }
            catch (IllegalAccessException e) {
                throw new CodeGenerationException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodeGenerationException(e.getTargetException());
            }
        }
    }

    protected static class BridgeMethodResolver {
        protected BridgeMethodResolver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Map<MethodSignature, MethodSignature> resolve(Map<Class<?>, Set<MethodSignature>> declToBridge) {
            HashMap<MethodSignature, MethodSignature> resolved = new HashMap<MethodSignature, MethodSignature>();
            Iterator<Map.Entry<Class<?>, Set<MethodSignature>>> iterator = declToBridge.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Class<?>, Set<MethodSignature>> entry = iterator.next();
                try {
                    Class<?> resource = entry.getKey();
                    ClassLoader classLoader = resource.getClassLoader();
                    InputStream is = classLoader.getResourceAsStream(ClassUtils.getFullyClassFileName(resource));
                    try {
                        if (is == null) {
                            HashMap<MethodSignature, MethodSignature> hashMap = resolved;
                            return hashMap;
                        }
                        new ClassReader(is).accept(new BridgedFinder(entry.getValue(), resolved), 6);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return resolved;
        }

        private static class BridgedFinder
        extends ClassVisitor {
            private MethodSignature currentMethod = null;
            private final Set<MethodSignature> eligibleMethods;
            private final Map<MethodSignature, MethodSignature> resolved;

            BridgedFinder(Set<MethodSignature> eligibleMethods, Map<MethodSignature, MethodSignature> resolved) {
                this.resolved = resolved;
                this.eligibleMethods = eligibleMethods;
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodSignature sig = new MethodSignature(name, desc);
                if (!this.eligibleMethods.remove(sig)) {
                    return null;
                }
                this.currentMethod = sig;
                class BridgedFinderMethodVisitor
                extends MethodVisitor {
                    BridgedFinderMethodVisitor() {
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if ((opcode == 183 || itf && opcode == 185) && BridgedFinder.this.currentMethod != null) {
                            MethodSignature target = new MethodSignature(name, desc);
                            if (!target.equals(BridgedFinder.this.currentMethod)) {
                                BridgedFinder.this.resolved.put(BridgedFinder.this.currentMethod, target);
                            }
                            BridgedFinder.this.currentMethod = null;
                        }
                    }
                }
                return new BridgedFinderMethodVisitor();
            }
        }
    }
}

