/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassInfo;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class MethodInfo {
    private static final Method[] OBJECT_METHODS;

    protected MethodInfo() {
    }

    public abstract ClassInfo getClassInfo();

    public abstract int getModifiers();

    public abstract MethodSignature getSignature();

    public abstract Type[] getExceptionTypes();

    public boolean equals(Object o) {
        return o == this || o instanceof MethodInfo && this.getSignature().equals(((MethodInfo)o).getSignature());
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public String toString() {
        return this.getSignature().toString();
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getSignature().getName());
    }

    public static MethodInfo from(Member member) {
        return MethodInfo.from(member, member.getModifiers());
    }

    public static MethodInfo from(final Member member, final int modifiers) {
        return new MethodInfo(){
            private ClassInfo ci;
            MethodSignature sig;

            @Override
            public ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = ClassInfo.from(member.getDeclaringClass());
                }
                return this.ci;
            }

            @Override
            public int getModifiers() {
                return modifiers;
            }

            @Override
            public MethodSignature getSignature() {
                if (this.sig == null) {
                    this.sig = MethodSignature.from(member);
                }
                return this.sig;
            }

            @Override
            public Type[] getExceptionTypes() {
                return Type.getExceptionTypes(member);
            }
        };
    }

    public static List<Method> addAllMethods(Class<?> type, List<Method> list) {
        if (type == Object.class) {
            CollectionUtils.addAll(list, (Object[])OBJECT_METHODS);
        } else {
            Collections.addAll(list, type.getDeclaredMethods());
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            MethodInfo.addAllMethods(superclass, list);
        }
        for (Class<?> interface_ : type.getInterfaces()) {
            MethodInfo.addAllMethods(interface_, list);
        }
        return list;
    }

    static {
        Method[] declaredMethods = Object.class.getDeclaredMethods();
        ArrayList<Method> objectMethods = new ArrayList<Method>(declaredMethods.length);
        for (Method method : declaredMethods) {
            if ("finalize".equals(method.getName()) || (method.getModifiers() & 0x18) > 0) continue;
            objectMethods.add(method);
        }
        OBJECT_METHODS = ReflectionUtils.toMethodArray(objectMethods);
    }
}

