/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.GeneratorAdapter;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.commons.TableSwitchGenerator;
import cn.taketoday.bytecode.core.Block;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.core.Customizer;
import cn.taketoday.bytecode.core.CustomizerRegistry;
import cn.taketoday.bytecode.core.HashCodeCustomizer;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.ObjectSwitchCallback;
import cn.taketoday.bytecode.core.ProcessArrayCallback;
import cn.taketoday.core.MultiValueMap;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class EmitUtils {
    public static final Type TYPE_BIG_INTEGER = Type.fromInternalName("java/math/BigInteger");
    public static final Type TYPE_BIG_DECIMAL = Type.fromInternalName("java/math/BigDecimal");
    private static final MethodSignature CSTRUCT_THROWABLE = MethodSignature.forConstructor("Throwable");
    private static final MethodSignature LENGTH = MethodSignature.from("int length()");
    private static final MethodSignature GET_NAME = MethodSignature.from("String getName()");
    private static final MethodSignature SET_LENGTH = MethodSignature.from("void setLength(int)");
    private static final MethodSignature FOR_NAME = MethodSignature.from("Class forName(String)");
    private static final MethodSignature STRING_CHAR_AT = MethodSignature.from("char charAt(int)");
    private static final MethodSignature APPEND_INT = MethodSignature.from("StringBuffer append(int)");
    private static final MethodSignature APPEND_LONG = MethodSignature.from("StringBuffer append(long)");
    private static final MethodSignature APPEND_CHAR = MethodSignature.from("StringBuffer append(char)");
    private static final MethodSignature APPEND_FLOAT = MethodSignature.from("StringBuffer append(float)");
    private static final MethodSignature APPEND_DOUBLE = MethodSignature.from("StringBuffer append(double)");
    private static final MethodSignature APPEND_STRING = MethodSignature.from("StringBuffer append(String)");
    private static final MethodSignature APPEND_BOOLEAN = MethodSignature.from("StringBuffer append(boolean)");
    private static final MethodSignature FLOAT_TO_INT_BITS = MethodSignature.from("int floatToIntBits(float)");
    private static final MethodSignature DOUBLE_TO_LONG_BITS = MethodSignature.from("long doubleToLongBits(double)");
    private static final MethodSignature GET_DECLARED_METHOD = MethodSignature.from("java.lang.reflect.Method getDeclaredMethod(String, Class[])");
    public static final ArrayDelimiters DEFAULT_DELIMITERS = new ArrayDelimiters("{", ", ", "}");

    public static void factoryMethod(ClassEmitter ce, MethodSignature sig) {
        CodeEmitter e = ce.beginMethod(1, sig, new Type[0]);
        e.new_instance_this();
        e.dup();
        e.loadArgs();
        e.invoke_constructor_this(MethodSignature.forConstructor(sig.getArgumentTypes()));
        e.returnValue();
        e.end_method();
    }

    public static void nullConstructor(ClassEmitter ce) {
        CodeEmitter e = ce.beginMethod(1, MethodSignature.EMPTY_CONSTRUCTOR, new Type[0]);
        e.loadThis();
        e.super_invoke_constructor();
        e.returnValue();
        e.end_method();
    }

    public static void processArray(GeneratorAdapter e, Type type, ProcessArrayCallback callback) {
        Type componentType = type.getComponentType();
        Local array = e.newLocal();
        Local loopvar = e.newLocal(Type.INT_TYPE);
        Label loopbody = e.newLabel();
        Label checkloop = e.newLabel();
        e.storeLocal(array);
        e.push(0);
        e.storeLocal(loopvar);
        e.goTo(checkloop);
        e.mark(loopbody);
        e.loadLocal(array);
        e.loadLocal(loopvar);
        e.arrayLoad(componentType);
        callback.processElement(componentType);
        e.iinc(loopvar, 1);
        e.mark(checkloop);
        e.loadLocal(loopvar);
        e.loadLocal(array);
        e.arrayLength();
        e.ifICmp(155, loopbody);
    }

    public static void processArrays(CodeEmitter e, Type type, ProcessArrayCallback callback) {
        Type componentType = type.getComponentType();
        Local array1 = e.newLocal();
        Local array2 = e.newLocal();
        Local loopvar = e.newLocal(Type.INT_TYPE);
        Label loopbody = e.newLabel();
        Label checkloop = e.newLabel();
        e.storeLocal(array1);
        e.storeLocal(array2);
        e.push(0);
        e.storeLocal(loopvar);
        e.goTo(checkloop);
        e.mark(loopbody);
        e.loadLocal(array1);
        e.loadLocal(loopvar);
        e.arrayLoad(componentType);
        e.loadLocal(array2);
        e.loadLocal(loopvar);
        e.arrayLoad(componentType);
        callback.processElement(componentType);
        e.iinc(loopvar, 1);
        e.mark(checkloop);
        e.loadLocal(loopvar);
        e.loadLocal(array1);
        e.arrayLength();
        e.ifIcmp(155, loopbody);
    }

    public static void stringSwitch(CodeEmitter e, String[] strings, int switchStyle, ObjectSwitchCallback callback) {
        switch (switchStyle) {
            case 0: {
                EmitUtils.stringSwitchTrie(e, strings, callback);
                break;
            }
            case 1: {
                EmitUtils.stringSwitchHash(e, strings, callback, false);
                break;
            }
            case 2: {
                EmitUtils.stringSwitchHash(e, strings, callback, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown switch style " + switchStyle);
            }
        }
    }

    private static void stringSwitchTrie(final CodeEmitter e, String[] strings, final ObjectSwitchCallback callback) {
        final Label def = e.newLabel();
        final Label end = e.newLabel();
        final MultiValueMap<Integer, String> buckets = CollectionUtils.buckets(strings, String::length);
        e.dup();
        e.invokeVirtual(Type.TYPE_STRING, LENGTH);
        e.tableSwitch(EmitUtils.getSwitchKeys(buckets), new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label ignore_end) {
                List bucket = (List)buckets.get(key);
                EmitUtils.stringSwitchHelper(e, bucket, callback, def, end, 0);
            }

            @Override
            public void generateDefault() {
                e.goTo(def);
            }
        });
        e.mark(def);
        e.pop();
        callback.processDefault();
        e.mark(end);
    }

    private static void stringSwitchHelper(final CodeEmitter e, List strings, final ObjectSwitchCallback callback, final Label def, final Label end, final int index) {
        final int len = ((String)strings.get(0)).length();
        final MultiValueMap<Object, Object> buckets = CollectionUtils.buckets(strings, value -> (int)((String)value).charAt(index));
        e.dup();
        e.push(index);
        e.invokeVirtual(Type.TYPE_STRING, STRING_CHAR_AT);
        e.tableSwitch(EmitUtils.getSwitchKeys(buckets), new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label ignore_end) {
                List bucket = (List)buckets.get(key);
                if (index + 1 == len) {
                    e.pop();
                    callback.processCase(bucket.get(0), end);
                } else {
                    EmitUtils.stringSwitchHelper(e, bucket, callback, def, end, index + 1);
                }
            }

            @Override
            public void generateDefault() {
                e.goTo(def);
            }
        });
    }

    protected static <T> int[] getSwitchKeys(Map<Integer, List<T>> buckets) {
        int[] keys = new int[buckets.size()];
        int i = 0;
        for (Integer k : buckets.keySet()) {
            keys[i++] = k;
        }
        Arrays.sort(keys);
        return keys;
    }

    private static void stringSwitchHash(final CodeEmitter e, String[] strings, final ObjectSwitchCallback callback, final boolean skipEquals) {
        final MultiValueMap<Integer, String> buckets = CollectionUtils.buckets(strings, Object::hashCode);
        final Label def = e.newLabel();
        final Label end = e.newLabel();
        e.dup();
        e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.HASH_CODE);
        e.tableSwitch(EmitUtils.getSwitchKeys(buckets), new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label ignore_end) {
                List bucket = (List)buckets.get(key);
                Label next = null;
                if (skipEquals && bucket.size() == 1) {
                    e.pop();
                    callback.processCase(bucket.get(0), end);
                } else {
                    Iterator it = bucket.iterator();
                    while (it.hasNext()) {
                        String string = (String)it.next();
                        if (next != null) {
                            e.mark(next);
                        }
                        if (it.hasNext()) {
                            e.dup();
                        }
                        e.push(string);
                        e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.EQUALS);
                        if (it.hasNext()) {
                            next = e.newLabel();
                            e.ifJump(153, next);
                            e.pop();
                        } else {
                            e.ifJump(153, def);
                        }
                        callback.processCase(string, end);
                    }
                }
            }

            @Override
            public void generateDefault() {
                e.pop();
            }
        });
        e.mark(def);
        callback.processDefault();
        e.mark(end);
    }

    public static void loadClassThis(CodeEmitter e) {
        EmitUtils.loadClassHelper(e, e.getClassEmitter().getClassType());
    }

    public static void loadClass(CodeEmitter e, Type type) {
        if (type.isPrimitive()) {
            if (type == Type.VOID_TYPE) {
                throw new IllegalArgumentException("cannot load void type");
            }
            e.getStatic(type.getBoxedType(), "TYPE", Type.TYPE_CLASS);
        } else {
            EmitUtils.loadClassHelper(e, type);
        }
    }

    private static void loadClassHelper(CodeEmitter e, Type type) {
        if (e.isStaticHook()) {
            e.push(type.emulateClassGetName());
            e.invokeStatic(Type.TYPE_CLASS, FOR_NAME);
        } else {
            String typeName;
            String fieldName;
            ClassEmitter ce = e.getClassEmitter();
            if (!ce.isFieldDeclared(fieldName = "$today$LoadClass$".concat(EmitUtils.escapeType(typeName = type.emulateClassGetName())))) {
                ce.declare_field(26, fieldName, Type.TYPE_CLASS, null);
                CodeEmitter hook = ce.getStaticHook();
                hook.push(typeName);
                hook.invokeStatic(Type.TYPE_CLASS, FOR_NAME);
                hook.putStatic(ce.getClassType(), fieldName, Type.TYPE_CLASS);
            }
            e.getField(fieldName);
        }
    }

    public static void pushArray(CodeEmitter e, Object[] array) {
        e.push(array.length);
        e.newArray(Type.fromClass(EmitUtils.remapComponentType(array.getClass().getComponentType())));
        for (int i = 0; i < array.length; ++i) {
            e.dup();
            e.push(i);
            EmitUtils.pushObject(e, array[i]);
            e.aastore();
        }
    }

    private static Class<?> remapComponentType(Class<?> componentType) {
        return componentType.equals(Type.class) ? Class.class : componentType;
    }

    public static void pushObject(CodeEmitter e, Object obj) {
        if (obj == null) {
            e.visitInsn(1);
        } else {
            Class<?> type = obj.getClass();
            if (type.isArray()) {
                EmitUtils.pushArray(e, (Object[])obj);
            } else if (obj instanceof String) {
                e.push((String)obj);
            } else if (obj instanceof Type) {
                EmitUtils.loadClass(e, (Type)obj);
            } else if (obj instanceof Class) {
                EmitUtils.loadClass(e, Type.fromClass((Class)obj));
            } else if (obj instanceof BigInteger) {
                e.newInstance(TYPE_BIG_INTEGER);
                e.dup();
                e.push(obj.toString());
                e.invokeConstructor(TYPE_BIG_INTEGER);
            } else if (obj instanceof BigDecimal) {
                e.newInstance(TYPE_BIG_DECIMAL);
                e.dup();
                e.push(obj.toString());
                e.invokeConstructor(TYPE_BIG_DECIMAL);
            } else {
                throw new IllegalArgumentException("unknown type: " + obj.getClass());
            }
        }
    }

    @Deprecated
    public static void hashCode(GeneratorAdapter e, Type type, int multiplier, Customizer customizer) {
        EmitUtils.hashCode(e, type, multiplier, CustomizerRegistry.singleton(customizer));
    }

    public static void hashCode(GeneratorAdapter e, Type type, int multiplier, CustomizerRegistry registry) {
        if (type.isArray()) {
            EmitUtils.hashArray(e, type, multiplier, registry);
        } else {
            e.swap(Type.INT_TYPE, type);
            e.push(multiplier);
            e.math(104, Type.INT_TYPE);
            e.swap(type, Type.INT_TYPE);
            if (type.isPrimitive()) {
                EmitUtils.hashPrimitive(e, type);
            } else {
                EmitUtils.hashObject(e, type, registry);
            }
            e.math(96, Type.INT_TYPE);
        }
    }

    private static void hashArray(GeneratorAdapter e, Type type, int multiplier, CustomizerRegistry registry) {
        Label skip = e.newLabel();
        Label end = e.newLabel();
        e.dup();
        e.ifNull(skip);
        EmitUtils.processArray(e, type, t -> EmitUtils.hashCode(e, t, multiplier, registry));
        e.goTo(end);
        e.mark(skip);
        e.pop();
        e.mark(end);
    }

    private static void hashObject(GeneratorAdapter e, Type type, CustomizerRegistry registry) {
        Label skip = e.newLabel();
        Label end = e.newLabel();
        e.dup();
        e.ifNull(skip);
        boolean customHashCode = false;
        for (HashCodeCustomizer hashCodeCustomizer : registry.get(HashCodeCustomizer.class)) {
            if (!hashCodeCustomizer.customize(e, type)) continue;
            customHashCode = true;
            break;
        }
        if (!customHashCode) {
            for (Customizer customizer : registry.get(Customizer.class)) {
                customizer.customize(e, type);
            }
            e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.HASH_CODE);
        }
        e.goTo(end);
        e.mark(skip);
        e.pop();
        e.push(0);
        e.mark(end);
    }

    private static void hashPrimitive(GeneratorAdapter e, Type type) {
        switch (type.getSort()) {
            case 1: {
                e.push(1);
                e.math(130, Type.INT_TYPE);
                break;
            }
            case 6: {
                e.invokeStatic(Type.TYPE_FLOAT, FLOAT_TO_INT_BITS);
                break;
            }
            case 8: {
                e.invokeStatic(Type.TYPE_DOUBLE, DOUBLE_TO_LONG_BITS);
            }
            case 7: {
                EmitUtils.hashLong(e);
            }
        }
    }

    private static void hashLong(GeneratorAdapter e) {
        e.dup2();
        e.push(32);
        e.math(124, Type.LONG_TYPE);
        e.math(130, Type.LONG_TYPE);
        e.cast(Type.LONG_TYPE, Type.INT_TYPE);
    }

    public static void notEquals(final CodeEmitter e, Type type, final Label notEquals, final CustomizerRegistry registry) {
        ProcessArrayCallback processArrayCallback = new ProcessArrayCallback(){

            @Override
            public void processElement(Type type) {
                EmitUtils.notEqualsHelper(e, type, notEquals, registry, this);
            }
        };
        processArrayCallback.processElement(type);
    }

    private static void notEqualsHelper(CodeEmitter e, Type type, Label notEquals, CustomizerRegistry registry, ProcessArrayCallback callback) {
        if (type.isPrimitive()) {
            e.ifCmp(type, 154, notEquals);
        } else {
            Label end = e.newLabel();
            EmitUtils.nullcmp(e, notEquals, end);
            if (type.isArray()) {
                Label checkContents = e.newLabel();
                e.dup2();
                e.arrayLength();
                e.swap();
                e.arrayLength();
                e.ifIcmp(153, checkContents);
                e.pop2();
                e.goTo(notEquals);
                e.mark(checkContents);
                EmitUtils.processArrays(e, type, callback);
            } else {
                List<Customizer> customizers = registry.get(Customizer.class);
                if (!customizers.isEmpty()) {
                    for (Customizer customizer : customizers) {
                        customizer.customize(e, type);
                    }
                    e.swap();
                    for (Customizer customizer : customizers) {
                        customizer.customize(e, type);
                    }
                }
                e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.EQUALS);
                e.ifJump(153, notEquals);
            }
            e.mark(end);
        }
    }

    private static void nullcmp(CodeEmitter e, Label oneNull, Label bothNull) {
        e.dup2();
        Label nonNull = e.newLabel();
        Label oneNullHelper = e.newLabel();
        Label end = e.newLabel();
        e.ifNonNull(nonNull);
        e.ifNonNull(oneNullHelper);
        e.pop2();
        e.goTo(bothNull);
        e.mark(nonNull);
        e.ifNull(oneNullHelper);
        e.goTo(end);
        e.mark(oneNullHelper);
        e.pop2();
        e.goTo(oneNull);
        e.mark(end);
    }

    public static void appendString(final CodeEmitter e, Type type, ArrayDelimiters delims, final CustomizerRegistry registry) {
        final ArrayDelimiters d = delims != null ? delims : DEFAULT_DELIMITERS;
        ProcessArrayCallback callback = new ProcessArrayCallback(){

            @Override
            public void processElement(Type type) {
                EmitUtils.appendStringHelper(e, type, d, registry, this);
                e.push(d.inside);
                e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        };
        EmitUtils.appendStringHelper(e, type, d, registry, callback);
    }

    private static void appendStringHelper(CodeEmitter e, Type type, ArrayDelimiters delims, CustomizerRegistry registry, ProcessArrayCallback callback) {
        Label skip = e.newLabel();
        Label end = e.newLabel();
        if (type.isPrimitive()) {
            switch (type.getSort()) {
                case 3: 
                case 4: 
                case 5: {
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_INT);
                    break;
                }
                case 8: {
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_DOUBLE);
                    break;
                }
                case 6: {
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_FLOAT);
                    break;
                }
                case 7: {
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_LONG);
                    break;
                }
                case 1: {
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_BOOLEAN);
                    break;
                }
                case 2: {
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_CHAR);
                    break;
                }
            }
        } else if (type.isArray()) {
            e.dup();
            e.ifNull(skip);
            e.swap();
            if (delims != null && delims.before != null && !"".equals(delims.before)) {
                e.push(delims.before);
                e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_STRING);
                e.swap();
            }
            EmitUtils.processArray(e, type, callback);
            EmitUtils.shrinkStringBuffer(e, 2);
            if (delims != null && delims.after != null && !"".equals(delims.after)) {
                e.push(delims.after);
                e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        } else {
            e.dup();
            e.ifNull(skip);
            for (Customizer customizer : registry.get(Customizer.class)) {
                customizer.customize(e, type);
            }
            e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.TO_STRING);
            e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_STRING);
        }
        e.goTo(end);
        e.mark(skip);
        e.pop();
        e.push("null");
        e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_STRING);
        e.mark(end);
    }

    private static void shrinkStringBuffer(CodeEmitter e, int amt) {
        e.dup();
        e.dup();
        e.invokeVirtual(Type.TYPE_STRING_BUFFER, LENGTH);
        e.push(amt);
        e.math(100, Type.INT_TYPE);
        e.invokeVirtual(Type.TYPE_STRING_BUFFER, SET_LENGTH);
    }

    public static void loadMethod(CodeEmitter e, MethodInfo method) {
        EmitUtils.loadClass(e, method.getClassInfo().getType());
        e.push(method.getSignature().getName());
        EmitUtils.pushObject(e, method.getSignature().getArgumentTypes());
        e.invokeVirtual(Type.TYPE_CLASS, GET_DECLARED_METHOD);
    }

    public static void methodSwitch(CodeEmitter e, List methods, ObjectSwitchCallback callback) {
        EmitUtils.memberSwitchHelper(e, methods, callback, true);
    }

    public static void constructorSwitch(CodeEmitter e, List constructors, ObjectSwitchCallback callback) {
        EmitUtils.memberSwitchHelper(e, constructors, callback, false);
    }

    private static void memberSwitchHelper(final CodeEmitter e, List members, final ObjectSwitchCallback callback, boolean useName) {
        try {
            HashMap cache = new HashMap();
            final ParameterTyper cached = member -> {
                Type[] types = (Type[])cache.get(member);
                if (types == null) {
                    types = member.getSignature().getArgumentTypes();
                    cache.put(member, types);
                }
                return types;
            };
            final Label def = e.newLabel();
            final Label end = e.newLabel();
            if (useName) {
                e.swap();
                final MultiValueMap<String, MethodInfo> buckets = CollectionUtils.buckets(members, value -> value.getSignature().getName());
                String[] names = StringUtils.toStringArray(buckets.keySet());
                EmitUtils.stringSwitch(e, names, 1, new ObjectSwitchCallback(){

                    @Override
                    public void processCase(Object key, Label dontUseEnd) {
                        EmitUtils.memberHelperSize(e, (List)buckets.get(key), callback, cached, def, end);
                    }

                    @Override
                    public void processDefault() {
                        e.goTo(def);
                    }
                });
            } else {
                EmitUtils.memberHelperSize(e, members, callback, cached, def, end);
            }
            e.mark(def);
            e.pop();
            callback.processDefault();
            e.mark(end);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CodeGenerationException(ex);
        }
    }

    private static void memberHelperSize(final CodeEmitter e, List members, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end) {
        final MultiValueMap<Integer, MethodInfo> buckets = CollectionUtils.buckets(members, value -> typer.getParameterTypes((MethodInfo)value).length);
        e.dup();
        e.arrayLength();
        e.tableSwitch(EmitUtils.getSwitchKeys(buckets), new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label dontUseEnd) {
                EmitUtils.memberHelperType(e, (List)buckets.get(key), callback, typer, def, end, new BitSet());
            }

            @Override
            public void generateDefault() {
                e.goTo(def);
            }
        });
    }

    private static void memberHelperType(final CodeEmitter e, List<MethodInfo> members, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end, final BitSet checked) {
        if (members.size() == 1) {
            MethodInfo member = members.get(0);
            Type[] types = typer.getParameterTypes(member);
            for (int i = 0; i < types.length; ++i) {
                if (checked != null && checked.get(i)) continue;
                e.dup();
                e.aaload(i);
                e.invokeVirtual(Type.TYPE_CLASS, GET_NAME);
                e.push(types[i].emulateClassGetName());
                e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.EQUALS);
                e.ifJump(153, def);
            }
            e.pop();
            callback.processCase(member, end);
        } else {
            Type[] example = typer.getParameterTypes(members.get(0));
            MultiValueMap<String, MethodInfo> buckets = null;
            int index = -1;
            for (int i = 0; i < example.length; ++i) {
                int j = i;
                MultiValueMap<String, MethodInfo> test = CollectionUtils.buckets(members, value -> {
                    Type[] parameterTypes = typer.getParameterTypes((MethodInfo)value);
                    return parameterTypes[j].emulateClassGetName();
                });
                if (buckets != null && test.size() <= buckets.size()) continue;
                buckets = test;
                index = i;
            }
            if (buckets == null || buckets.size() == 1) {
                e.goTo(def);
            } else {
                checked.set(index);
                e.dup();
                e.aaload(index);
                e.invokeVirtual(Type.TYPE_CLASS, GET_NAME);
                final MultiValueMap<String, MethodInfo> fbuckets = buckets;
                String[] names = StringUtils.toStringArray(buckets.keySet());
                EmitUtils.stringSwitch(e, names, 1, new ObjectSwitchCallback(){

                    @Override
                    public void processCase(Object key, Label dontUseEnd) {
                        EmitUtils.memberHelperType(e, (List)fbuckets.get(key), callback, typer, def, end, checked);
                    }

                    @Override
                    public void processDefault() {
                        e.goTo(def);
                    }
                });
            }
        }
    }

    public static void wrapThrowable(Block block, Type wrapper) {
        CodeEmitter e = block.getCodeEmitter();
        e.catchException(block, Type.TYPE_THROWABLE);
        e.newInstance(wrapper);
        e.dupX1();
        e.swap();
        e.invokeConstructor(wrapper, CSTRUCT_THROWABLE);
        e.throwException();
    }

    public static void addProperties(ClassEmitter ce, String[] names, Type[] types) {
        for (int i = 0; i < names.length; ++i) {
            String fieldName = "$today_prop_" + names[i];
            ce.declare_field(2, fieldName, types[i], null);
            EmitUtils.addProperty(ce, names[i], types[i], fieldName);
        }
    }

    public static void addProperty(ClassEmitter ce, String name, Type type, String fieldName) {
        String property = StringUtils.capitalize(name);
        CodeEmitter e = ce.beginMethod(1, new MethodSignature(type, "get" + property, Type.EMPTY_ARRAY), new Type[0]);
        e.loadThis();
        e.getField(fieldName);
        e.returnValue();
        e.end_method();
        e = ce.beginMethod(1, new MethodSignature(Type.VOID_TYPE, "set" + property, type), new Type[0]);
        e.loadThis();
        e.loadArg(0);
        e.putField(fieldName);
        e.returnValue();
        e.end_method();
    }

    public static void wrapUndeclaredThrowable(CodeEmitter e, Block handler, Type[] exceptions, Type wrapper) {
        boolean needThrow;
        HashSet set = new HashSet();
        CollectionUtils.addAll(set, (Object[])exceptions);
        if (set.contains(Type.TYPE_THROWABLE)) {
            return;
        }
        boolean bl = needThrow = exceptions != null;
        if (!set.contains(Type.TYPE_RUNTIME_EXCEPTION)) {
            e.catchException(handler, Type.TYPE_RUNTIME_EXCEPTION);
            needThrow = true;
        }
        if (!set.contains(Type.TYPE_ERROR)) {
            e.catchException(handler, Type.TYPE_ERROR);
            needThrow = true;
        }
        if (exceptions != null) {
            for (Type exception : exceptions) {
                e.catchException(handler, exception);
            }
        }
        if (needThrow) {
            e.throwException();
        }
        e.catchException(handler, Type.TYPE_THROWABLE);
        e.newInstance(wrapper);
        e.dupX1();
        e.swap();
        e.invokeConstructor(wrapper, CSTRUCT_THROWABLE);
        e.throwException();
    }

    public static CodeEmitter beginMethod(ClassEmitter e, MethodInfo method) {
        return EmitUtils.beginMethod(e, method, method.getModifiers());
    }

    public static CodeEmitter beginMethod(ClassEmitter e, MethodInfo method, int access) {
        return e.beginMethod(access, method.getSignature(), method.getExceptionTypes());
    }

    public static void loadEmptyArguments(CodeEmitter codeEmitter) {
        codeEmitter.getStatic(Type.TYPE_CONSTANT, "EMPTY_OBJECTS", Type.TYPE_OBJECT_ARRAY);
    }

    public static String escapeType(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '$': {
                    sb.append("$24");
                    continue block9;
                }
                case '.': {
                    sb.append("$2E");
                    continue block9;
                }
                case '[': {
                    sb.append("$5B");
                    continue block9;
                }
                case ';': {
                    sb.append("$3B");
                    continue block9;
                }
                case '(': {
                    sb.append("$28");
                    continue block9;
                }
                case ')': {
                    sb.append("$29");
                    continue block9;
                }
                case '/': {
                    sb.append("$2F");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static class ArrayDelimiters {
        public final String before;
        public final String inside;
        public final String after;

        public ArrayDelimiters(String before, String inside, String after) {
            this.before = before;
            this.inside = inside;
            this.after = after;
        }
    }

    private static interface ParameterTyper {
        public Type[] getParameterTypes(MethodInfo var1);
    }
}

