/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class MethodSignature {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_CLASS_INIT = "<clinit>";
    public static final MethodSignature SIG_STATIC = new MethodSignature("<clinit>", "()V");
    public static final MethodSignature EMPTY_CONSTRUCTOR = new MethodSignature("<init>", "()V");
    public static final MethodSignature INT_VALUE = MethodSignature.from("int intValue()");
    public static final MethodSignature LONG_VALUE = MethodSignature.from("long longValue()");
    public static final MethodSignature CHAR_VALUE = MethodSignature.from("char charValue()");
    public static final MethodSignature FLOAT_VALUE = MethodSignature.from("float floatValue()");
    public static final MethodSignature DOUBLE_VALUE = MethodSignature.from("double doubleValue()");
    public static final MethodSignature BOOLEAN_VALUE = MethodSignature.from("boolean booleanValue()");
    public static final MethodSignature HASH_CODE = MethodSignature.from("int hashCode()");
    public static final MethodSignature GET_CLASS = MethodSignature.from("Class getClass()");
    public static final MethodSignature TO_STRING = MethodSignature.from("String toString()");
    public static final MethodSignature EQUALS = MethodSignature.from("boolean equals(Object)");
    public static final MethodSignature constructWithString = MethodSignature.forConstructor("String");
    private final String name;
    private final String descriptor;
    private volatile Type returnType;
    private volatile Type[] argumentTypes;

    public MethodSignature(String name, String descriptor) {
        this.name = name;
        this.descriptor = descriptor;
    }

    public MethodSignature(Type returnType, String name, Type ... argumentTypes) {
        this(name, Type.getMethodDescriptor(returnType, argumentTypes));
    }

    public static MethodSignature from(Method method) {
        return new MethodSignature(method.getName(), Type.getMethodDescriptor(method));
    }

    public static MethodSignature from(Constructor<?> constructor) {
        return new MethodSignature(CONSTRUCTOR_NAME, Type.getConstructorDescriptor(constructor));
    }

    public static MethodSignature from(Member member) {
        if (member instanceof Method) {
            return MethodSignature.from((Method)member);
        }
        if (member instanceof Constructor) {
            return MethodSignature.from((Constructor)member);
        }
        throw new IllegalArgumentException("Cannot get signature of " + member);
    }

    public static MethodSignature forConstructor(String parameterTypes) {
        String descriptor = Type.getDescriptor(parameterTypes);
        return new MethodSignature(CONSTRUCTOR_NAME, "(" + descriptor + ")V");
    }

    public static MethodSignature forConstructor(Type ... parameterTypes) {
        StringBuilder descriptor = new StringBuilder(parameterTypes.length * 8);
        for (Type type : parameterTypes) {
            descriptor.append(type.getDescriptor());
        }
        return new MethodSignature(CONSTRUCTOR_NAME, "(" + descriptor.toString() + ")V");
    }

    public static MethodSignature from(String method) {
        return MethodSignature.from(method, false);
    }

    public static MethodSignature from(String method, boolean defaultPackage) {
        int spaceIndex = method.indexOf(32);
        int argumentStartIndex = method.indexOf(40, spaceIndex) + 1;
        int endIndex = method.indexOf(41, argumentStartIndex);
        if (spaceIndex == -1 || argumentStartIndex == 0 || endIndex == -1) {
            throw new IllegalArgumentException();
        }
        String returnType = method.substring(0, spaceIndex);
        String methodName = method.substring(spaceIndex + 1, argumentStartIndex - 1).trim();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        String descriptor = Type.getDescriptor(method, argumentStartIndex, endIndex, defaultPackage);
        stringBuilder.append(descriptor);
        stringBuilder.append(')').append(Type.getDescriptor(returnType, defaultPackage));
        return new MethodSignature(methodName, stringBuilder.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturnType() {
        Type returnType = this.returnType;
        if (returnType == null) {
            MethodSignature methodSignature = this;
            synchronized (methodSignature) {
                returnType = this.returnType;
                if (returnType == null) {
                    this.returnType = returnType = Type.forReturnType(this.descriptor);
                }
            }
        }
        return returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type[] getArgumentTypes() {
        Type[] argumentTypes = this.argumentTypes;
        if (argumentTypes == null) {
            MethodSignature methodSignature = this;
            synchronized (methodSignature) {
                argumentTypes = this.argumentTypes;
                if (argumentTypes == null) {
                    argumentTypes = Type.getArgumentTypes(this.descriptor);
                    this.argumentTypes = argumentTypes;
                }
            }
        }
        return argumentTypes;
    }

    public String toString() {
        return this.name + this.descriptor;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MethodSignature) {
            MethodSignature otherMethod = (MethodSignature)other;
            return this.name.equals(otherMethod.name) && this.descriptor.equals(otherMethod.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.descriptor.hashCode();
    }
}

