/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.Attribute;
import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.FieldVisitor;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.ModuleVisitor;
import cn.taketoday.bytecode.RecordComponentVisitor;
import cn.taketoday.bytecode.TypePath;
import cn.taketoday.bytecode.commons.AnnotationRemapper;
import cn.taketoday.bytecode.commons.FieldRemapper;
import cn.taketoday.bytecode.commons.MethodRemapper;
import cn.taketoday.bytecode.commons.ModuleHashesAttribute;
import cn.taketoday.bytecode.commons.ModuleRemapper;
import cn.taketoday.bytecode.commons.RecordComponentRemapper;
import cn.taketoday.bytecode.commons.Remapper;
import cn.taketoday.lang.Nullable;
import java.util.List;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    protected ClassRemapper(ClassVisitor classVisitor, Remapper remapper) {
        super(classVisitor);
        this.remapper = remapper;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        Remapper remapper = this.remapper;
        super.visit(version, access, remapper.mapType(name), remapper.mapSignature(signature, false), remapper.mapType(superName), interfaces == null ? null : remapper.mapTypes(interfaces));
    }

    @Override
    public ModuleVisitor visitModule(String name, int flags, String version) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(name), flags, version);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(descriptor, annotationVisitor);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(descriptor, annotationVisitor);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            List<String> modules = moduleHashesAttribute.modules;
            int size = modules.size();
            for (int i = 0; i < size; ++i) {
                modules.set(i, this.remapper.mapModuleName(modules.get(i)));
            }
        }
        super.visitAttribute(attribute);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        Remapper remapper = this.remapper;
        RecordComponentVisitor recordComponentVisitor = super.visitRecordComponent(remapper.mapRecordComponentName(this.className, name, descriptor), remapper.mapDesc(descriptor), remapper.mapSignature(signature, true));
        return this.createRecordComponentRemapper(recordComponentVisitor);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        Remapper remapper = this.remapper;
        FieldVisitor fieldVisitor = super.visitField(access, remapper.mapFieldName(this.className, name, descriptor), remapper.mapDesc(descriptor), remapper.mapSignature(signature, true), value == null ? null : remapper.mapValue(value));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        Remapper remapper = this.remapper;
        String remappedDescriptor = remapper.mapMethodDesc(descriptor);
        MethodVisitor methodVisitor = super.visitMethod(access, remapper.mapMethodName(this.className, name, descriptor), remappedDescriptor, remapper.mapSignature(signature, false), exceptions == null ? null : remapper.mapTypes(exceptions));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        Remapper remapper = this.remapper;
        super.visitInnerClass(remapper.mapType(name), outerName == null ? null : remapper.mapType(outerName), innerName == null ? null : remapper.mapInnerClassName(name, outerName, innerName), access);
    }

    @Override
    public void visitOuterClass(String owner, String name, String descriptor) {
        Remapper remapper = this.remapper;
        super.visitOuterClass(remapper.mapType(owner), name == null ? null : remapper.mapMethodName(owner, name, descriptor), descriptor == null ? null : remapper.mapMethodDesc(descriptor));
    }

    @Override
    public void visitNestHost(String nestHost) {
        super.visitNestHost(this.remapper.mapType(nestHost));
    }

    @Override
    public void visitNestMember(String nestMember) {
        super.visitNestMember(this.remapper.mapType(nestMember));
    }

    @Override
    public void visitPermittedSubclass(String permittedSubclass) {
        super.visitPermittedSubclass(this.remapper.mapType(permittedSubclass));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(String descriptor, AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(descriptor, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(moduleVisitor, this.remapper);
    }

    @Nullable
    protected RecordComponentVisitor createRecordComponentRemapper(@Nullable RecordComponentVisitor recordComponentVisitor) {
        if (recordComponentVisitor == null) {
            return null;
        }
        return new RecordComponentRemapper(recordComponentVisitor, this.remapper);
    }
}

