/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.util.ReflectionUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public abstract class ImmutableBean {
    private static final Type ILLEGAL_STATE_EXCEPTION = Type.fromInternalName("java/lang/IllegalStateException");
    private static final MethodSignature CSTRUCT_OBJECT = MethodSignature.forConstructor("Object");
    private static final Class[] OBJECT_CLASSES = new Class[]{Object.class};
    private static final String FIELD_NAME = "today$RWbean";

    public static Object create(Object bean) {
        Generator gen = new Generator();
        gen.setBean(bean);
        return gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private Object bean;
        private Class target;

        public Generator() {
            super(ImmutableBean.class);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            this.target = bean.getClass();
            this.setNeighbor(this.target);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.target);
        }

        public Object create() {
            String name = this.target.getName();
            this.setNamePrefix(name);
            return super.create(name);
        }

        @Override
        public void generateClass(ClassVisitor v) {
            Type targetType = Type.fromClass(this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), targetType, null, "<cglibGenerated>");
            ce.declare_field(18, ImmutableBean.FIELD_NAME, targetType, null);
            CodeEmitter e = ce.beginMethod(1, CSTRUCT_OBJECT, new Type[0]);
            e.loadThis();
            e.super_invoke_constructor();
            e.loadThis();
            e.loadArg(0);
            e.checkCast(targetType);
            e.putField(ImmutableBean.FIELD_NAME);
            e.returnValue();
            e.end_method();
            PropertyDescriptor[] descriptors = CglibReflectUtils.getBeanProperties(this.target);
            Method[] getters = CglibReflectUtils.getPropertyMethods(descriptors, true, false);
            Method[] setters = CglibReflectUtils.getPropertyMethods(descriptors, false, true);
            for (Method value : getters) {
                MethodInfo getter = MethodInfo.from(value);
                e = EmitUtils.beginMethod(ce, getter, 1);
                e.loadThis();
                e.getField(ImmutableBean.FIELD_NAME);
                e.invoke(getter);
                e.returnValue();
                e.end_method();
            }
            for (Method method : setters) {
                MethodInfo setter = MethodInfo.from(method);
                e = EmitUtils.beginMethod(ce, setter, 1);
                e.throwException(ILLEGAL_STATE_EXCEPTION, "Bean is immutable");
                e.end_method();
            }
            ce.endClass();
        }

        protected Object firstInstance(Class type) {
            return ReflectionUtils.newInstance(type, OBJECT_CLASSES, new Object[]{this.bean});
        }

        @Override
        protected Object nextInstance(Object instance) {
            return this.firstInstance((Class)instance.getClass());
        }
    }
}

