/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.beans.BulkBeanEmitter;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;

public abstract class BulkBean {
    protected Class target;
    protected String[] getters;
    protected String[] setters;
    protected Class[] types;

    protected BulkBean() {
    }

    public abstract void getPropertyValues(Object var1, Object[] var2);

    public abstract void setPropertyValues(Object var1, Object[] var2);

    public Object[] getPropertyValues(Object bean) {
        Object[] values = new Object[this.getters.length];
        this.getPropertyValues(bean, values);
        return values;
    }

    public Class[] getPropertyTypes() {
        return (Class[])this.types.clone();
    }

    public String[] getGetters() {
        return (String[])this.getters.clone();
    }

    public String[] getSetters() {
        return (String[])this.setters.clone();
    }

    public static BulkBean create(Class target, String[] getters, String[] setters, Class[] types) {
        Generator gen = new Generator();
        gen.setTarget(target);
        gen.setGetters(getters);
        gen.setSetters(setters);
        gen.setTypes(types);
        return gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private Class target;
        private String[] getters;
        private String[] setters;
        private Class[] types;

        public Generator() {
            super(BulkBean.class);
        }

        public void setTarget(Class target) {
            this.target = target;
            this.setNeighbor(target);
        }

        public void setGetters(String[] getters) {
            this.getters = getters;
        }

        public void setSetters(String[] setters) {
            this.setters = setters;
        }

        public void setTypes(Class[] types) {
            this.types = types;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.target);
        }

        public BulkBean create() {
            this.setNamePrefix(this.target.getName());
            String targetClassName = this.target.getName();
            String[] typeNames = CglibReflectUtils.getNames(this.types);
            BulkBeanKey key = new BulkBeanKey(targetClassName, this.getters == null ? null : Arrays.asList(this.getters), this.setters == null ? null : Arrays.asList(this.setters), typeNames == null ? null : Arrays.asList(typeNames));
            return (BulkBean)super.create(key);
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new BulkBeanEmitter(v, this.getClassName(), this.target, this.getters, this.setters, this.types);
        }

        protected Object firstInstance(Class type) {
            BulkBean instance = (BulkBean)ReflectionUtils.newInstance(type);
            instance.target = this.target;
            int length = this.getters.length;
            instance.getters = new String[length];
            System.arraycopy(this.getters, 0, instance.getters, 0, length);
            instance.setters = new String[length];
            System.arraycopy(this.setters, 0, instance.setters, 0, length);
            instance.types = new Class[this.types.length];
            System.arraycopy(this.types, 0, instance.types, 0, this.types.length);
            return instance;
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    record BulkBeanKey(String target, List<String> getters, List<String> setters, List<String> types) {
    }
}

