/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.engine;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.BlockList;
import ai.djl.nn.ParameterList;
import ai.djl.nn.SymbolBlock;
import ai.djl.pytorch.engine.PtNDManager;
import ai.djl.pytorch.jni.IValueUtils;
import ai.djl.pytorch.jni.JniUtils;
import ai.djl.pytorch.jni.NativeResource;
import ai.djl.pytorch.jni.Pointer;
import ai.djl.training.ParameterStore;
import ai.djl.training.initializer.Initializer;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtSymbolBlock
extends NativeResource
implements SymbolBlock {
    private static final Logger logger = LoggerFactory.getLogger(PtSymbolBlock.class);
    private PtNDManager manager;
    private boolean isTrain;
    private PairList<String, Shape> inputDescriptions;
    private PairList<String, Shape> outputDescriptions;
    private boolean first;

    public PtSymbolBlock(PtNDManager manager, Pointer handle) {
        super(handle);
        this.manager = manager;
        manager.attach(this.getUid(), this);
        this.isTrain = true;
        this.first = true;
    }

    @Override
    public void close() {
        Pointer pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            JniUtils.deleteModule(pointer);
            this.manager.detach(this.getUid());
            this.manager = null;
        }
    }

    public void removeLastBlock() {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NDList forward(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        if (this.isTrain != training) {
            this.isTrain = training;
            if (this.isTrain) {
                JniUtils.enableTrainingMode(this);
            } else {
                JniUtils.enableInferenceMode(this);
            }
        }
        if (!this.first) return IValueUtils.forward(this, inputs, training);
        Class<PtSymbolBlock> clazz = PtSymbolBlock.class;
        synchronized (PtSymbolBlock.class) {
            if (!this.first) return IValueUtils.forward(this, inputs, training);
            this.inputDescriptions = new PairList();
            this.outputDescriptions = new PairList();
            for (NDArray array : inputs) {
                this.inputDescriptions.add((Object)array.getName(), (Object)array.getShape());
            }
            NDList outputs = IValueUtils.forward(this, inputs, training);
            for (NDArray array : outputs) {
                this.outputDescriptions.add((Object)array.getName(), (Object)array.getShape());
            }
            this.first = false;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return outputs;
        }
    }

    public void setInitializer(Initializer initializer) {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    public void setInitializer(Initializer initializer, String paramName) {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    public Shape[] initialize(NDManager manager, DataType dataType, Shape ... inputShapes) {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    public boolean isInitialized() {
        return true;
    }

    public void cast(DataType dataType) {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    public PairList<String, Shape> describeInput() {
        if (this.inputDescriptions == null) {
            logger.warn("Input shapes are unknown, please run predict or forward onceand call describeInput again.");
        }
        return this.inputDescriptions;
    }

    public PairList<String, Shape> describeOutput() {
        if (this.outputDescriptions == null) {
            logger.warn("Output shapes are unknown, please run predict or forward onceand call describeOutput again.");
        }
        return this.outputDescriptions;
    }

    public BlockList getChildren() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ParameterList getDirectParameters() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ParameterList getParameters() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Shape getParameterShape(String name, Shape[] inputShapes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        return new Shape[0];
    }

    public void saveParameters(DataOutputStream os) {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }

    public void loadParameters(NDManager manager, DataInputStream is) {
        throw new UnsupportedOperationException("Not supported for PyTorch");
    }
}

