/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.jni;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "djl_torch";
    private static final String NATIVE_LIB_NAME = "torch";

    private LibUtils() {
    }

    public static void loadLibrary() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null) {
            String nativeLibDir = LibUtils.findNativeLibrary();
            if (nativeLibDir != null) {
                libName = LibUtils.copyJniLibraryFromClasspath(Paths.get(nativeLibDir, new String[0]));
            } else {
                throw new IllegalStateException("Native library not found");
            }
        }
        logger.debug("Loading pytorch library from: {}", (Object)libName);
        if (System.getProperty("os.name").startsWith("Win")) {
            LibUtils.loadWinDependencies(libName);
        }
        System.load(libName);
    }

    private static void loadWinDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        if (libDir == null) {
            throw new IllegalArgumentException("Invalid library path!");
        }
        try (Stream<Path> paths = Files.walk(libDir, new FileVisitOption[0]);){
            paths.filter(path -> {
                String name = path.getFileName().toString();
                return !"c10_cuda.dll".equals(name) && !"torch.dll".equals(name) && Files.isRegularFile(path, new LinkOption[0]) && !name.endsWith("djl_torch.dll");
            }).map(path -> path.toAbsolutePath().toString()).forEach(System::load);
            if (Files.exists(libDir.resolve("c10_cuda.dll"), new LinkOption[0])) {
                System.load(libDir.resolve("c10_cuda.dll").toAbsolutePath().toString());
            }
            System.load(libDir.resolve("torch.dll").toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Folder not exist! " + libDir, e);
        }
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("PYTORCH_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        List<String> mappedLibNames = Collections.singletonList(System.mapLibraryName(LIB_NAME));
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            for (String name : mappedLibNames) {
                if (p.isFile() && p.getName().endsWith(name)) {
                    return p.getAbsolutePath();
                }
                File file = new File(path, name);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private static String copyJniLibraryFromClasspath(Path nativeDir) {
        String string;
        block19: {
            String name = System.mapLibraryName(LIB_NAME);
            Platform platform = Platform.fromSystem();
            String classifier = platform.getClassifier();
            String flavor = platform.getFlavor();
            if (flavor.isEmpty()) {
                flavor = "cpu";
            }
            Properties prop = new Properties();
            try (InputStream stream = LibUtils.class.getResourceAsStream("/jnilib/" + classifier + "/" + flavor + "/pytorch.properties");){
                prop.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find pytorch property file", e);
            }
            String version = prop.getProperty("version");
            Path path = nativeDir.resolve(version + flavor + name);
            if (Files.exists(path, new LinkOption[0])) {
                return path.toAbsolutePath().toString();
            }
            InputStream stream = LibUtils.class.getResourceAsStream("/jnilib/" + classifier + "/" + flavor + "/" + name);
            try {
                Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                string = path.toAbsolutePath().toString();
                if (stream == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot copy jni files", e);
                }
            }
            stream.close();
        }
        return string;
    }

    private static synchronized String findNativeLibrary() {
        ArrayList<URL> urls;
        try {
            urls = Collections.list(Thread.currentThread().getContextClassLoader().getResources("native/lib/pytorch.properties"));
        }
        catch (IOException e) {
            return null;
        }
        if (urls.isEmpty()) {
            return null;
        }
        Platform systemPlatform = Platform.fromSystem();
        try {
            Platform matching = null;
            Platform placeholder = null;
            for (URL url : urls) {
                Platform platform = Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                return LibUtils.copyNativeLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadPyTorch(placeholder);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download PyTorch native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read PyTorch native library jar properties", e);
        }
        throw new IllegalStateException("Your PyTorch native library jar does not match your operating system. Make sure the Maven Dependency Classifier matches your system type.");
    }

    private static String copyNativeLibraryFromClasspath(Platform platform) {
        String string;
        block15: {
            Path tmp = null;
            String version = platform.getVersion();
            String flavor = platform.getFlavor();
            String classifier = platform.getClassifier();
            try {
                String userHome = System.getProperty("user.home");
                String libName = System.mapLibraryName(NATIVE_LIB_NAME);
                Path dir = Paths.get(userHome, ".pytorch/cache/" + version + flavor + '-' + classifier);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = dir.toAbsolutePath().toString();
                    return string2;
                }
                tmp = Paths.get(userHome, ".pytorch/cache/tmp");
                Files.createDirectories(tmp, new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.deleteQuietly((Path)dir);
                Files.move(tmp, dir, new CopyOption[0]);
                tmp = null;
                string = dir.toAbsolutePath().toString();
                if (tmp == null) break block15;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract PyTorch native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String downloadPyTorch(Platform platform) throws IOException {
        String version = platform.getVersion();
        String flavor = platform.getFlavor();
        if (flavor.isEmpty()) {
            flavor = "cpu";
        }
        String classifier = platform.getClassifier();
        String os = platform.getOsPrefix();
        String userHome = System.getProperty("user.home");
        String libName = System.mapLibraryName(NATIVE_LIB_NAME);
        Path dir = Paths.get(userHome, ".pytorch/cache/" + version + flavor + '-' + classifier);
        Path path = dir.resolve(libName);
        if (Files.exists(path, new LinkOption[0])) {
            return dir.toAbsolutePath().toString();
        }
        Path tmp = Paths.get(userHome, ".pytorch/cache/tmp");
        Files.createDirectories(tmp, new FileAttribute[0]);
        String[] versions = version.split("-");
        String link = "https://djl-ai.s3.amazonaws.com/publish/pytorch-" + versions[0];
        try {
            String string;
            block18: {
                InputStream is = new URL(link + "/files.txt").openStream();
                try {
                    List lines = Utils.readLines((InputStream)is);
                    for (String line : lines) {
                        if (!line.startsWith(flavor + '/' + os + '/')) continue;
                        URL url = new URL(link + '/' + line);
                        String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
                        try (GZIPInputStream fis = new GZIPInputStream(url.openStream());){
                            Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    Utils.deleteQuietly((Path)dir);
                    Files.move(tmp, dir, new CopyOption[0]);
                    tmp = null;
                    string = dir.toAbsolutePath().toString();
                    if (is == null) break block18;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
        finally {
            if (tmp != null) {
                Utils.deleteQuietly((Path)tmp);
            }
        }
    }
}

