/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.jni;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "djl_torch";
    private static final String NATIVE_LIB_NAME = "torch";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static void loadLibrary() {
        if ("http://www.android.com/".equals(System.getProperty("java.vendor.url"))) {
            System.loadLibrary(LIB_NAME);
            return;
        }
        String libName = LibUtils.getLibName();
        logger.debug("Loading pytorch library from: {}", (Object)libName);
        if (System.getProperty("os.name").startsWith("Win")) {
            LibUtils.loadWinDependencies(libName);
        }
        LibUtils.loadNativeLibrary(libName);
    }

    public static String getLibName() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null) {
            AtomicBoolean fallback = new AtomicBoolean(false);
            String nativeLibDir = LibUtils.findNativeLibrary(fallback);
            if (nativeLibDir != null) {
                libName = LibUtils.copyJniLibraryFromClasspath(Paths.get(nativeLibDir, new String[0]), fallback.get());
            } else {
                throw new IllegalStateException("Native library not found");
            }
        }
        return libName;
    }

    private static void loadWinDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        if (libDir == null) {
            throw new IllegalArgumentException("Invalid library path!");
        }
        HashSet<String> loadLater = new HashSet<String>(Arrays.asList("c10_cuda.dll", "torch.dll", "torch_cpu.dll", "torch_cuda.dll", "torch_cuda_cpp.dll", "torch_cuda_cu.dll", "fbgemm.dll"));
        try (Stream<Path> paths = Files.walk(libDir, new FileVisitOption[0]);){
            paths.filter(path -> {
                String name = path.getFileName().toString();
                return !loadLater.contains(name) && Files.isRegularFile(path, new LinkOption[0]) && !name.endsWith("djl_torch.dll") && !name.startsWith("cudnn");
            }).map(path -> path.toAbsolutePath().toString()).forEach(System::load);
            LibUtils.loadNativeLibrary(libDir.resolve("fbgemm.dll").toAbsolutePath().toString());
            LibUtils.loadNativeLibrary(libDir.resolve("torch_cpu.dll").toAbsolutePath().toString());
            if (Files.exists(libDir.resolve("c10_cuda.dll"), new LinkOption[0])) {
                if (Files.exists(libDir.resolve("cudnn64_8.dll"), new LinkOption[0])) {
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn64_8.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn_ops_infer64_8.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn_ops_train64_8.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn_cnn_infer64_8.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn_cnn_train64_8.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn_adv_infer64_8.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn_adv_train64_8.dll").toAbsolutePath().toString());
                } else if (Files.exists(libDir.resolve("cudnn64_7.dll"), new LinkOption[0])) {
                    LibUtils.loadNativeLibrary(libDir.resolve("cudnn64_7.dll").toAbsolutePath().toString());
                }
                LibUtils.loadNativeLibrary(libDir.resolve("c10_cuda.dll").toAbsolutePath().toString());
                if (Files.exists(libDir.resolve("torch_cuda_cpp.dll"), new LinkOption[0])) {
                    LibUtils.loadNativeLibrary(libDir.resolve("torch_cuda_cpp.dll").toAbsolutePath().toString());
                    LibUtils.loadNativeLibrary(libDir.resolve("torch_cuda_cu.dll").toAbsolutePath().toString());
                }
                LibUtils.loadNativeLibrary(libDir.resolve("torch_cuda.dll").toAbsolutePath().toString());
            }
            LibUtils.loadNativeLibrary(libDir.resolve("torch.dll").toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Folder not exist! " + libDir, e);
        }
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("PYTORCH_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        List<String> mappedLibNames = Collections.singletonList(System.mapLibraryName(LIB_NAME));
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            for (String name : mappedLibNames) {
                if (p.isFile() && p.getName().endsWith(name)) {
                    return p.getAbsolutePath();
                }
                File file = new File(path, name);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String copyJniLibraryFromClasspath(Path nativeDir, boolean fallback) {
        String string;
        InputStream stream;
        Path tmp;
        block25: {
            block24: {
                Path precxx11Lib;
                String name = System.mapLibraryName(LIB_NAME);
                Platform platform = Platform.fromSystem();
                String classifier = platform.getClassifier();
                String flavor = platform.getFlavor();
                if (fallback) {
                    flavor = "cpu";
                }
                if (Files.exists(precxx11Lib = nativeDir.resolve("libstdc++.so.6"), new LinkOption[0])) {
                    flavor = flavor + "-precxx11";
                }
                Properties prop = new Properties();
                try (InputStream stream2 = LibUtils.class.getResourceAsStream("/jnilib/pytorch.properties");){
                    prop.load(stream2);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot find pytorch property file", e);
                }
                String version = prop.getProperty("version");
                Path path = nativeDir.resolve(version + '-' + flavor + '-' + name);
                if (Files.exists(path, new LinkOption[0])) {
                    return path.toAbsolutePath().toString();
                }
                tmp = null;
                String libPath = "/jnilib/" + classifier + '/' + flavor + '/' + name;
                logger.info("Extracting {} to cache ...", (Object)libPath);
                stream = LibUtils.class.getResourceAsStream(libPath);
                if (stream == null) {
                    throw new IllegalStateException("PyTorch jni not found: " + libPath);
                }
                tmp = Files.createTempFile(nativeDir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(stream, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
                string = path.toAbsolutePath().toString();
                if (stream == null) break block24;
                stream.close();
            }
            if (tmp == null) break block25;
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot copy jni files", e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private static synchronized String findNativeLibrary(AtomicBoolean fallback) {
        Enumeration<URL> urls;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("native/lib/pytorch.properties");
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            return null;
        }
        Platform systemPlatform = Platform.fromSystem();
        try {
            Platform matching = null;
            Platform placeholder = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Platform platform = Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform, false)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                if ("cpu".equals(matching.getFlavor())) {
                    fallback.set(true);
                }
                return LibUtils.copyNativeLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadPyTorch(placeholder, fallback);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download PyTorch native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read PyTorch native library jar properties", e);
        }
        throw new IllegalStateException("Your PyTorch native library jar does not match your operating system. Make sure the Maven Dependency Classifier matches your system type.");
    }

    private static String copyNativeLibraryFromClasspath(Platform platform) {
        String string;
        block17: {
            Path tmp = null;
            String version = platform.getVersion();
            String flavor = platform.getFlavor();
            if (Arrays.asList(platform.getLibraries()).contains("libstdc++.so.6")) {
                flavor = flavor + "-precxx11";
            }
            String classifier = platform.getClassifier();
            try {
                String libName = System.mapLibraryName(NATIVE_LIB_NAME);
                Path cacheDir = Utils.getEngineCacheDir((String)"pytorch");
                logger.debug("Using cache dir: {}", (Object)cacheDir);
                Path dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = dir.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheDir, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    logger.info("Extracting {} to cache ...", (Object)libPath);
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        if (is == null) {
                            throw new IllegalStateException("PyTorch library not found: " + libPath);
                        }
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = dir.toAbsolutePath().toString();
                if (tmp == null) break block17;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract PyTorch native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static void loadNativeLibrary(String path) {
        String nativeHelper = System.getProperty("ai.djl.pytorch.native_helper");
        if (nativeHelper != null && !nativeHelper.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(nativeHelper);
                Method method = clazz.getDeclaredMethod("load", String.class);
                method.invoke(null, path);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Invalid native_helper: " + nativeHelper, e);
            }
        }
        System.load(path);
    }

    /*
     * Exception decompiling
     */
    private static String downloadPyTorch(Platform platform, AtomicBoolean fallback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

