/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.jni;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "jni_fasttext";

    private LibUtils() {
    }

    public static void loadLibrary() {
        if (System.getProperty("os.name").startsWith("Win")) {
            throw new UnsupportedOperationException("Windows is not supported.");
        }
        String libName = LibUtils.copyJniLibraryFromClasspath();
        logger.debug("Loading fasttext library from: {}", (Object)libName);
        System.load(libName);
    }

    /*
     * Loose catch block
     */
    private static String copyJniLibraryFromClasspath() {
        String string;
        InputStream stream;
        Path tmp;
        block23: {
            block22: {
                String name = System.mapLibraryName(LIB_NAME);
                Path nativeDir = Utils.getEngineCacheDir((String)"fasttext");
                Properties prop = new Properties();
                Platform platform = Platform.fromSystem();
                String classifier = platform.getClassifier();
                try (InputStream stream2 = LibUtils.class.getResourceAsStream("/native/lib/fasttext.properties");){
                    prop.load(stream2);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read files", e);
                }
                String version = prop.getProperty("version");
                Path path = nativeDir.resolve(version).resolve(name);
                if (Files.exists(path, new LinkOption[0])) {
                    return path.toAbsolutePath().toString();
                }
                tmp = null;
                stream = LibUtils.class.getResourceAsStream("/native/lib/" + classifier + "/" + name);
                if (stream == null) {
                    throw new UnsupportedOperationException("fastText is not supported by this platform");
                }
                Files.createDirectories(nativeDir.resolve(version), new FileAttribute[0]);
                tmp = Files.createTempFile(nativeDir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(stream, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
                string = path.toAbsolutePath().toString();
                if (stream == null) break block22;
                stream.close();
            }
            if (tmp == null) break block23;
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot copy jni files", e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable3;
                }
            }
        }
    }
}

