/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.util;

import java.util.concurrent.TimeUnit;
import us.ihmc.realtime.MonotonicTime;
import us.ihmc.realtime.PeriodicParameters;
import us.ihmc.realtime.PeriodicRealtimeThread;
import us.ihmc.realtime.PriorityParameters;
import us.ihmc.util.PeriodicThreadScheduler;

public class PeriodicRealtimeThreadScheduler
implements PeriodicThreadScheduler {
    private final String name;
    private final PriorityParameters priorityParameters;
    private PeriodicRealtimeThread thread;

    public PeriodicRealtimeThreadScheduler(String name, int priority) {
        this(name, new PriorityParameters(priority));
    }

    public PeriodicRealtimeThreadScheduler(int priority) {
        this(null, new PriorityParameters(priority));
    }

    public PeriodicRealtimeThreadScheduler(PriorityParameters priorityParameters) {
        this(null, priorityParameters);
    }

    public PeriodicRealtimeThreadScheduler(String name, PriorityParameters priorityParameters) {
        this.name = name;
        this.priorityParameters = priorityParameters;
    }

    @Override
    public void schedule(Runnable runnable, long period, TimeUnit timeunit) {
        if (this.thread != null) {
            throw new RuntimeException("Thread has already been scheduled");
        }
        MonotonicTime time = new MonotonicTime(0L, TimeUnit.NANOSECONDS.convert(period, timeunit));
        PeriodicParameters periodicParameters = new PeriodicParameters(time);
        this.thread = new PeriodicRealtimeThread(this.priorityParameters, periodicParameters, runnable, this.name);
        this.thread.start();
    }

    @Override
    public void shutdown() {
        this.thread.shutdown();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.thread.join();
    }
}

