/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.runtime.barrierScheduler.implicitContext;

import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.ParkingBarrier;

public abstract class Task<C>
implements Runnable {
    private final long divisor;
    private final ParkingBarrier barrier = new ParkingBarrier();
    private boolean initialized;
    private boolean shutdownRequested = false;
    private boolean hasShutdown = false;

    public Task(long divisor) {
        if (divisor <= 0L) {
            throw new IllegalArgumentException("divisor must be > 0");
        }
        this.divisor = divisor;
    }

    protected abstract boolean initialize();

    protected abstract void execute();

    protected abstract void cleanup();

    protected abstract void updateMasterContext(C var1);

    protected abstract void updateLocalContext(C var1);

    boolean isPending(long schedulerTick) {
        return schedulerTick % this.divisor == 0L;
    }

    boolean isSleeping() {
        return this.barrier.isSleeping();
    }

    boolean release() {
        return this.barrier.release();
    }

    void requestShutdown() {
        this.shutdownRequested = true;
        if (this.isSleeping()) {
            this.release();
        }
    }

    public boolean hasShutdown() {
        return this.hasShutdown;
    }

    @Override
    public final void run() {
        while (!this.shutdownRequested) {
            this.barrier.await();
            if (this.shutdownRequested) continue;
            if (!this.initialized) {
                this.initialized = this.initialize();
            }
            if (!this.initialized) continue;
            this.execute();
        }
        this.cleanup();
        this.hasShutdown = true;
    }
}

