/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.ekf.filter.state.ComposedState;
import us.ihmc.ekf.filter.state.State;

public class ComposedSensor
extends Sensor {
    private final List<Sensor> subSensors = new ArrayList<Sensor>();
    private final Map<Sensor, MutableInt> sensorIndexMap = new HashMap<Sensor, MutableInt>();
    private final ComposedState sensorState;
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);
    private final String name;

    public ComposedSensor(String name) {
        this.name = name;
        this.sensorState = new ComposedState(name + "State");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addSensor(Sensor sensorToAdd) {
        if (sensorToAdd == null) {
            return;
        }
        if (this.sensorIndexMap.containsKey(sensorToAdd)) {
            throw new RuntimeException("Trying to add a state with name " + sensorToAdd.getName() + " twice.");
        }
        if (sensorToAdd instanceof ComposedSensor) {
            ((ComposedSensor)sensorToAdd).subSensors.forEach(this::addSensor);
            return;
        }
        int oldSize = this.getMeasurementSize();
        this.sensorIndexMap.put(sensorToAdd, new MutableInt(oldSize));
        this.subSensors.add(sensorToAdd);
        this.sensorState.addState(sensorToAdd.getSensorState());
    }

    @Override
    public State getSensorState() {
        return this.sensorState;
    }

    public int getStartIndex(Sensor sensor) {
        MutableInt startIndex = this.sensorIndexMap.get(sensor);
        if (startIndex == null) {
            throw new RuntimeException("Do not have sub sensor " + sensor.getName());
        }
        return startIndex.intValue();
    }

    @Override
    public int getMeasurementSize() {
        if (this.subSensors.isEmpty()) {
            return 0;
        }
        Sensor lastSubSensor = this.subSensors.get(this.subSensors.size() - 1);
        return this.getStartIndex(lastSubSensor) + lastSubSensor.getMeasurementSize();
    }

    @Override
    public void getMeasurementJacobian(DMatrix1Row jacobianToPack, RobotState robotState) {
        jacobianToPack.reshape(this.getMeasurementSize(), robotState.getSize());
        CommonOps_DDRM.fill((DMatrixD1)jacobianToPack, (double)0.0);
        for (int i = 0; i < this.subSensors.size(); ++i) {
            Sensor subSensor = this.subSensors.get(i);
            int startIndex = this.getStartIndex(subSensor);
            subSensor.getMeasurementJacobian((DMatrix1Row)this.tempMatrix, robotState);
            CommonOps_DDRM.insert((DMatrix)this.tempMatrix, (DMatrix)jacobianToPack, (int)startIndex, (int)0);
        }
    }

    @Override
    public void getResidual(DMatrix1Row residualToPack, RobotState robotState) {
        residualToPack.reshape(this.getMeasurementSize(), 1);
        CommonOps_DDRM.fill((DMatrixD1)residualToPack, (double)0.0);
        for (int i = 0; i < this.subSensors.size(); ++i) {
            Sensor subSensor = this.subSensors.get(i);
            int startIndex = this.getStartIndex(subSensor);
            subSensor.getResidual((DMatrix1Row)this.tempMatrix, robotState);
            CommonOps_DDRM.insert((DMatrix)this.tempMatrix, (DMatrix)residualToPack, (int)startIndex, (int)0);
        }
    }

    @Override
    public void getRMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(this.getMeasurementSize(), this.getMeasurementSize());
        CommonOps_DDRM.fill((DMatrixD1)matrixToPack, (double)0.0);
        for (int i = 0; i < this.subSensors.size(); ++i) {
            Sensor subSensor = this.subSensors.get(i);
            int startIndex = this.getStartIndex(subSensor);
            subSensor.getRMatrix((DMatrix1Row)this.tempMatrix);
            CommonOps_DDRM.insert((DMatrix)this.tempMatrix, (DMatrix)matrixToPack, (int)startIndex, (int)startIndex);
        }
    }
}

