/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Optional;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.RobotStateIndexProvider;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FilterTools {
    public static ProccessNoiseModel proccessNoiseModel = ProccessNoiseModel.ONLY_ACCELERATION_VARIANCE;

    public static void insertForVelocity(DMatrix1Row matrixToPack, List<String> oneDofJointNames, DMatrix1Row matrixToInsert, RobotStateIndexProvider indexProvider) {
        int rows = matrixToInsert.getNumRows();
        matrixToPack.reshape(rows, indexProvider.getSize());
        matrixToPack.zero();
        int index = 0;
        if (indexProvider.isFloating()) {
            CommonOps_DDRM.extract((DMatrix)matrixToInsert, (int)0, (int)rows, (int)0, (int)3, (DMatrix)matrixToPack, (int)0, (int)indexProvider.findAngularVelocityIndex());
            CommonOps_DDRM.extract((DMatrix)matrixToInsert, (int)0, (int)rows, (int)3, (int)6, (DMatrix)matrixToPack, (int)0, (int)indexProvider.findLinearVelocityIndex());
            index += 6;
        }
        for (int jointIndex = 0; jointIndex < oneDofJointNames.size(); ++jointIndex) {
            int indexInState = indexProvider.findJointVelocityIndex(oneDofJointNames.get(jointIndex));
            CommonOps_DDRM.extract((DMatrix)matrixToInsert, (int)0, (int)rows, (int)index, (int)(index + 1), (DMatrix)matrixToPack, (int)0, (int)indexInState);
            ++index;
        }
    }

    public static void insertForAcceleration(DMatrix1Row matrixToPack, List<String> oneDofJointNames, DMatrix1Row matrixToInsert, RobotStateIndexProvider indexProvider) {
        int rows = matrixToInsert.getNumRows();
        matrixToPack.reshape(rows, indexProvider.getSize());
        matrixToPack.zero();
        int index = 0;
        if (indexProvider.isFloating()) {
            CommonOps_DDRM.extract((DMatrix)matrixToInsert, (int)0, (int)rows, (int)0, (int)3, (DMatrix)matrixToPack, (int)0, (int)indexProvider.findAngularAccelerationIndex());
            CommonOps_DDRM.extract((DMatrix)matrixToInsert, (int)0, (int)rows, (int)3, (int)6, (DMatrix)matrixToPack, (int)0, (int)indexProvider.findLinearAccelerationIndex());
            index += 6;
        }
        for (int jointIndex = 0; jointIndex < oneDofJointNames.size(); ++jointIndex) {
            int indexInState = indexProvider.findJointAccelerationIndex(oneDofJointNames.get(jointIndex));
            CommonOps_DDRM.extract((DMatrix)matrixToInsert, (int)0, (int)rows, (int)index, (int)(index + 1), (DMatrix)matrixToPack, (int)0, (int)indexInState);
            ++index;
        }
    }

    public static void packQd(DMatrix1Row qdToPack, List<String> oneDofJointNames, DMatrix1Row stateVector, RobotStateIndexProvider indexProvider) {
        qdToPack.reshape(oneDofJointNames.size() + (indexProvider.isFloating() ? 6 : 0), 1);
        int index = 0;
        if (indexProvider.isFloating()) {
            int angularIndex = indexProvider.findAngularVelocityIndex();
            int linearIndex = indexProvider.findLinearVelocityIndex();
            CommonOps_DDRM.extract((DMatrix)stateVector, (int)angularIndex, (int)(angularIndex + 3), (int)0, (int)1, (DMatrix)qdToPack, (int)0, (int)0);
            CommonOps_DDRM.extract((DMatrix)stateVector, (int)linearIndex, (int)(linearIndex + 3), (int)0, (int)1, (DMatrix)qdToPack, (int)3, (int)0);
            index += 6;
        }
        for (int jointIndex = 0; jointIndex < oneDofJointNames.size(); ++jointIndex) {
            int indexInState = indexProvider.findJointVelocityIndex(oneDofJointNames.get(jointIndex));
            qdToPack.set(index, stateVector.get(indexInState));
            ++index;
        }
    }

    public static void packQdd(DMatrix1Row qddToPack, List<String> oneDofJointNames, DMatrix1Row stateVector, RobotStateIndexProvider indexProvider) {
        qddToPack.reshape(oneDofJointNames.size() + (indexProvider.isFloating() ? 6 : 0), 1);
        int index = 0;
        if (indexProvider.isFloating()) {
            int angularIndex = indexProvider.findAngularAccelerationIndex();
            int linearIndex = indexProvider.findLinearAccelerationIndex();
            CommonOps_DDRM.extract((DMatrix)stateVector, (int)angularIndex, (int)(angularIndex + 3), (int)0, (int)1, (DMatrix)qddToPack, (int)0, (int)0);
            CommonOps_DDRM.extract((DMatrix)stateVector, (int)linearIndex, (int)(linearIndex + 3), (int)0, (int)1, (DMatrix)qddToPack, (int)3, (int)0);
            index += 6;
        }
        for (int jointIndex = 0; jointIndex < oneDofJointNames.size(); ++jointIndex) {
            int indexInState = indexProvider.findJointAccelerationIndex(oneDofJointNames.get(jointIndex));
            qddToPack.set(index, stateVector.get(indexInState));
            ++index;
        }
    }

    public static void checkVectorDimensions(DMatrix1Row A, DMatrix1Row B) {
        if (A.getNumRows() != B.getNumRows()) {
            throw new RuntimeException("Got states of different sizes.");
        }
        if (A.getNumCols() != 1 || B.getNumCols() != 1) {
            throw new RuntimeException("States are expected to be row vectors.");
        }
    }

    public static void setIdentity(DMatrix1Row matrix, int size) {
        matrix.reshape(size, size);
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrix);
    }

    public static void packQref(double dt, DMatrix1Row Qref, int dim) {
        switch (proccessNoiseModel) {
            case PIECEWISE_CONTINUOUS_ACCELERATION: {
                FilterTools.packQForPiecewiseContinuousAcceleration(dt, Qref, dim);
                break;
            }
            case CONTINUOUS_ACCELERATION: {
                FilterTools.packQForContinuousAcceleration(dt, Qref, dim);
                break;
            }
            case ONLY_ACCELERATION_VARIANCE: {
                FilterTools.packQForOnlyAccelerationVariance(Qref, dim);
                break;
            }
            default: {
                throw new RuntimeException("Implement " + (Object)((Object)proccessNoiseModel) + " model.");
            }
        }
    }

    public static void packQForPiecewiseContinuousAcceleration(double dt, DMatrix1Row Qref, int dim) {
        Qref.reshape(dim * 3, dim * 3);
        for (int i = 0; i < dim; ++i) {
            Qref.set(0 * dim + i, 0 * dim + i, dt * dt * dt * dt / 4.0);
            Qref.set(1 * dim + i, 0 * dim + i, dt * dt * dt / 2.0);
            Qref.set(0 * dim + i, 1 * dim + i, dt * dt * dt / 2.0);
            Qref.set(1 * dim + i, 1 * dim + i, dt * dt);
            Qref.set(2 * dim + i, 0 * dim + i, dt * dt / 2.0);
            Qref.set(0 * dim + i, 2 * dim + i, dt * dt / 2.0);
            Qref.set(1 * dim + i, 2 * dim + i, dt);
            Qref.set(2 * dim + i, 1 * dim + i, dt);
            Qref.set(2 * dim + i, 2 * dim + i, 1.0);
        }
    }

    public static void packQForContinuousAcceleration(double dt, DMatrix1Row Qref, int dim) {
        Qref.reshape(dim * 3, dim * 3);
        for (int i = 0; i < dim; ++i) {
            Qref.set(0 * dim + i, 0 * dim + i, dt * dt * dt * dt * dt / 20.0);
            Qref.set(1 * dim + i, 0 * dim + i, dt * dt * dt * dt / 8.0);
            Qref.set(0 * dim + i, 1 * dim + i, dt * dt * dt * dt / 8.0);
            Qref.set(1 * dim + i, 1 * dim + i, dt * dt * dt / 3.0);
            Qref.set(2 * dim + i, 0 * dim + i, dt * dt * dt / 6.0);
            Qref.set(0 * dim + i, 2 * dim + i, dt * dt * dt / 6.0);
            Qref.set(1 * dim + i, 2 * dim + i, dt * dt / 2.0);
            Qref.set(2 * dim + i, 1 * dim + i, dt * dt / 2.0);
            Qref.set(2 * dim + i, 2 * dim + i, dt);
        }
    }

    public static void packQForOnlyAccelerationVariance(DMatrix1Row Qref, int dim) {
        Qref.reshape(dim * 3, dim * 3);
        Qref.zero();
        for (int i = 0; i < dim; ++i) {
            Qref.set(2 * dim + i, 2 * dim + i, 1.0);
        }
    }

    public static String stringToPrefix(String string) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string);
    }

    public static DoubleParameter findOrCreate(String name, YoRegistry registry, double initialValue) {
        Optional<YoParameter> parameter = registry.getParameters().stream().filter(p -> p.getName().equals(name)).findFirst();
        if (parameter.isPresent()) {
            return (DoubleParameter)parameter.get();
        }
        return new DoubleParameter(name, registry, initialValue);
    }

    public static enum ProccessNoiseModel {
        CONTINUOUS_ACCELERATION,
        PIECEWISE_CONTINUOUS_ACCELERATION,
        ONLY_ACCELERATION_VARIANCE;

    }
}

