/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor.implementations;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MagneticFieldSensor
extends Sensor {
    private final String sensorName;
    private final double sqrtHz;
    private final DoubleProvider variance;
    private final ReferenceFrame measurementFrame;
    private final Vector3D measurement = new Vector3D();
    private final FrameVector3D north = new FrameVector3D(ReferenceFrame.getWorldFrame(), 1.0, 0.0, 0.0);
    private final FrameVector3D expectedMeasurement = new FrameVector3D();
    private final RigidBodyBasics measurementBody;
    private final Matrix3D orientationJacobian = new Matrix3D();
    private final RigidBodyTransform rootToMeasurement = new RigidBodyTransform();
    private final RigidBodyTransform rootTransform = new RigidBodyTransform();

    public MagneticFieldSensor(String sensorName, double dt, RigidBodyBasics measurementBody, ReferenceFrame measurementFrame, YoRegistry registry) {
        this.sensorName = sensorName;
        this.measurementFrame = measurementFrame;
        this.measurementBody = measurementBody;
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.variance = FilterTools.findOrCreate(sensorName + "Variance", registry, 1.0);
    }

    public void setNorth(FrameVector3D magneticFieldDirectionInWorld) {
        magneticFieldDirectionInWorld.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.north.setAndNormalize((FrameTuple3DReadOnly)magneticFieldDirectionInWorld);
    }

    public void setMeasurement(Vector3DReadOnly magneticFieldDirection) {
        this.measurement.setAndNormalize((Tuple3DReadOnly)magneticFieldDirection);
    }

    @Override
    public String getName() {
        return this.sensorName;
    }

    @Override
    public int getMeasurementSize() {
        return 3;
    }

    @Override
    public void getMeasurementJacobian(DMatrix1Row jacobianToPack, RobotState robotState) {
        if (!robotState.isFloating()) {
            throw new RuntimeException("This sensor is currently only supported for floating robots.");
        }
        jacobianToPack.reshape(this.getMeasurementSize(), robotState.getSize());
        CommonOps_DDRM.fill((DMatrixD1)jacobianToPack, (double)0.0);
        this.computeExpectedMeasurement();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)this.measurementBody);
        JointBasics rootJoint = (JointBasics)rootBody.getChildrenJoints().get(0);
        MovingReferenceFrame rootFrame = rootJoint.getFrameAfterJoint();
        MovingReferenceFrame baseFrame = rootJoint.getFrameBeforeJoint();
        rootFrame.getTransformToDesiredFrame(this.rootToMeasurement, this.measurementFrame);
        baseFrame.getTransformToDesiredFrame(this.rootTransform, (ReferenceFrame)rootFrame);
        this.orientationJacobian.setToTildeForm((Tuple3DReadOnly)this.expectedMeasurement);
        this.orientationJacobian.multiply((Matrix3DReadOnly)this.rootToMeasurement.getRotation());
        this.orientationJacobian.multiply((Matrix3DReadOnly)this.rootTransform.getRotation());
        this.orientationJacobian.get(0, robotState.findOrientationIndex(), (DMatrix)jacobianToPack);
    }

    @Override
    public void getResidual(DMatrix1Row residualToPack, RobotState robotState) {
        this.computeExpectedMeasurement();
        residualToPack.reshape(this.getMeasurementSize(), 1);
        residualToPack.set(0, this.measurement.getX() - this.expectedMeasurement.getX());
        residualToPack.set(1, this.measurement.getY() - this.expectedMeasurement.getY());
        residualToPack.set(2, this.measurement.getZ() - this.expectedMeasurement.getZ());
    }

    private void computeExpectedMeasurement() {
        this.expectedMeasurement.setIncludingFrame((FrameTuple3DReadOnly)this.north);
        this.expectedMeasurement.changeFrame(this.measurementFrame);
    }

    @Override
    public void getRMatrix(DMatrix1Row noiseCovarianceToPack) {
        noiseCovarianceToPack.reshape(this.getMeasurementSize(), this.getMeasurementSize());
        CommonOps_DDRM.setIdentity((DMatrix1Row)noiseCovarianceToPack);
        CommonOps_DDRM.scale((double)(this.variance.getValue() * this.sqrtHz), (DMatrixD1)noiseCovarianceToPack);
    }
}

