/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.yosql.logging.api;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import java.util.Set;
import wtf.metio.yosql.codegen.exceptions.CodeGenerationException;
import wtf.metio.yosql.logging.api.LoggingGenerator;
import wtf.metio.yosql.models.constants.api.LoggingApis;
import wtf.metio.yosql.models.immutables.ApiConfiguration;

public final class DelegatingLoggingGenerator
implements LoggingGenerator {
    private final ApiConfiguration apiConfiguration;
    private final Set<LoggingGenerator> generators;

    public DelegatingLoggingGenerator(ApiConfiguration apiConfiguration, Set<LoggingGenerator> generators) {
        this.apiConfiguration = apiConfiguration;
        this.generators = generators;
    }

    @Override
    public boolean supports(LoggingApis api) {
        return this.generators.stream().anyMatch(generator -> generator.supports(api));
    }

    @Override
    public CodeBlock queryPicked(String fieldName) {
        return this.log().queryPicked(fieldName);
    }

    @Override
    public CodeBlock indexPicked(String fieldName) {
        return this.log().indexPicked(fieldName);
    }

    @Override
    public CodeBlock vendorQueryPicked(String fieldName) {
        return this.log().vendorQueryPicked(fieldName);
    }

    @Override
    public CodeBlock vendorIndexPicked(String fieldName) {
        return this.log().vendorIndexPicked(fieldName);
    }

    @Override
    public CodeBlock vendorDetected() {
        return this.log().vendorDetected();
    }

    @Override
    public CodeBlock executingQuery() {
        return this.log().executingQuery();
    }

    @Override
    public CodeBlock shouldLog() {
        return this.log().shouldLog();
    }

    @Override
    public boolean isEnabled() {
        return this.log().isEnabled();
    }

    @Override
    public Optional<FieldSpec> logger(TypeName repoClass) {
        return this.log().logger(repoClass);
    }

    @Override
    public CodeBlock entering(String repository, String method) {
        return this.log().entering(repository, method);
    }

    private LoggingGenerator log() {
        return this.generators.stream().filter(generator -> generator.supports(this.apiConfiguration.loggingApi())).findFirst().orElseThrow(() -> new CodeGenerationException("TODO: add error message for missing support for " + this.apiConfiguration.loggingApi()));
    }
}

