/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util.concurrent;

import cn.taketoday.lang.Assert;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public abstract class FutureUtils {
    public static <T> CompletableFuture<T> callAsync(Callable<T> callable) {
        Assert.notNull(callable, "Callable must not be null");
        CompletableFuture<T> result = new CompletableFuture<T>();
        return result.completeAsync(FutureUtils.toSupplier(callable, result));
    }

    public static <T> CompletableFuture<T> callAsync(Callable<T> callable, Executor executor) {
        Assert.notNull(callable, "Callable must not be null");
        Assert.notNull((Object)executor, "Executor must not be null");
        CompletableFuture<T> result = new CompletableFuture<T>();
        return result.completeAsync(FutureUtils.toSupplier(callable, result), executor);
    }

    private static <T> Supplier<T> toSupplier(Callable<T> callable, CompletableFuture<T> result) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception ex) {
                result.completeExceptionally(ex instanceof CompletionException ? ex : new CompletionException(ex));
                return null;
            }
        };
    }
}

