/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.core.ArraySizeTrimmer;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess,
ArraySizeTrimmer {
    private int size;
    private Object element;

    public SmartList() {
    }

    public SmartList(E element) {
        this.element = element;
        this.size = 1;
    }

    public SmartList(Collection<? extends E> elements) {
        int size = elements.size();
        if (size == 1) {
            E element = elements instanceof RandomAccess ? ((List)elements).get(0) : elements.iterator().next();
            this.add(element);
        } else if (size > 0) {
            this.size = size;
            this.element = elements.toArray(new Object[size]);
        }
    }

    @SafeVarargs
    public SmartList(E ... elements) {
        int length = elements.length;
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                this.element = elements[0];
                this.size = 1;
                break;
            }
            default: {
                this.element = Arrays.copyOf(elements, length);
                this.size = length;
            }
        }
    }

    @Override
    public E get(int index) {
        int size = this.size;
        SmartList.checkOutOfBounds(index, size, false);
        if (size == 1) {
            return this.asElement();
        }
        return this.asArray()[index];
    }

    private static void checkOutOfBounds(int index, int size, boolean inclusive) {
        if (index < 0 || (inclusive ? index > size : index >= size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    @Override
    public boolean add(E e) {
        int size = this.size;
        switch (size) {
            case 0: {
                this.element = e;
                break;
            }
            case 1: {
                this.element = new Object[]{this.element, e};
                break;
            }
            default: {
                E[] array = this.resizeIfNecessary(size);
                array[size] = e;
            }
        }
        ++this.size;
        ++this.modCount;
        return true;
    }

    private E[] resizeIfNecessary(int size) {
        E[] array = this.asArray();
        int oldCapacity = array.length;
        if (size >= oldCapacity) {
            int newCapacity = Math.max(oldCapacity * 3 / 2 + 1, size + 1);
            array = SmartList.realloc(array, newCapacity, Object[]::new);
            this.element = array;
        }
        return array;
    }

    public static <T> T[] realloc(T[] array, int newSize, IntFunction<T[]> factory) {
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        T[] result = factory.apply(newSize);
        if (newSize == 0) {
            return result;
        }
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    @Override
    public void add(int index, E e) {
        int size = this.size;
        SmartList.checkOutOfBounds(index, size, true);
        switch (size) {
            case 0: {
                this.element = e;
                break;
            }
            case 1: {
                Object[] objectArray;
                if (index == 0) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = e;
                    objectArray = objectArray2;
                    objectArray2[1] = this.element;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = this.element;
                    objectArray = objectArray3;
                    objectArray3[1] = e;
                }
                this.element = objectArray;
                break;
            }
            default: {
                E[] array = this.resizeIfNecessary(size);
                System.arraycopy(array, index, array, index + 1, size - index);
                array[index] = e;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.element = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E set(int index, E element) {
        E oldValue;
        int size = this.size;
        SmartList.checkOutOfBounds(index, size, false);
        if (size == 1) {
            oldValue = this.asElement();
            this.element = element;
        } else {
            E[] array = this.asArray();
            oldValue = array[index];
            array[index] = element;
        }
        return oldValue;
    }

    private E asElement() {
        return (E)this.element;
    }

    private E[] asArray() {
        return (Object[])this.element;
    }

    @Override
    public E remove(int index) {
        E oldValue;
        int size = this.size;
        SmartList.checkOutOfBounds(index, size, false);
        switch (size) {
            case 0: 
            case 1: {
                oldValue = this.asElement();
                this.element = null;
                break;
            }
            case 2: {
                E[] array = this.asArray();
                oldValue = array[index];
                this.element = array[1 - index];
                break;
            }
            default: {
                E[] array = this.asArray();
                oldValue = array[index];
                int numMoved = size - index - 1;
                if (numMoved > 0) {
                    System.arraycopy(array, index + 1, array, index, numMoved);
                }
                array[size - 1] = null;
            }
        }
        --this.size;
        ++this.modCount;
        return oldValue;
    }

    @Override
    public Iterator<E> iterator() {
        return this.size == 0 ? Collections.emptyIterator() : super.iterator();
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.size >= 2) {
            Arrays.sort(this.asArray(), 0, this.size, comparator);
        }
    }

    public int getModificationCount() {
        return this.modCount;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int aLength = a.length;
        int size = this.size;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                E t = this.asElement();
                if (aLength == 0) {
                    Object[] r = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
                    r[0] = t;
                    return r;
                }
                a[0] = t;
                break;
            }
            default: {
                if (aLength < size) {
                    return Arrays.copyOf(this.asArray(), size, a.getClass());
                }
                System.arraycopy(this.asArray(), 0, a, 0, size);
            }
        }
        if (aLength > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public void trimToSize() {
        int size = this.size;
        if (size < 2) {
            return;
        }
        E[] array = this.asArray();
        if (size < array.length) {
            ++this.modCount;
            this.element = Arrays.copyOf(array, size);
        }
    }

    @Override
    public int indexOf(Object o) {
        return switch (this.size) {
            case 0 -> -1;
            case 1 -> {
                if (Objects.equals(o, this.element)) {
                    yield 0;
                }
                yield -1;
            }
            default -> SmartList.indexOf(this.asArray(), o, 0, this.size);
        };
    }

    public static <T> int indexOf(T[] src, @Nullable T obj, int start, int end) {
        if (obj == null) {
            for (int i = start; i < end; ++i) {
                if (src[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!obj.equals(src[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SmartList) {
            return this.equalsWithSmartList((SmartList)o);
        }
        if (o instanceof ArrayList) {
            return this.equalsWithArrayList((ArrayList)o);
        }
        return super.equals(o);
    }

    private boolean equalsWithSmartList(SmartList<?> that) {
        int size = this.size;
        if (size != that.size) {
            return false;
        }
        return switch (size) {
            case 0 -> true;
            case 1 -> Objects.equals(this.element, that.element);
            default -> this.compareOneByOne(size, that);
        };
    }

    private boolean equalsWithArrayList(ArrayList<?> that) {
        int size = this.size;
        if (size != that.size()) {
            return false;
        }
        return switch (size) {
            case 0 -> true;
            case 1 -> Objects.equals(this.element, that.get(0));
            default -> this.compareOneByOne(size, that);
        };
    }

    private boolean compareOneByOne(int size, List<?> that) {
        E[] array = this.asArray();
        for (int i = 0; i < size; ++i) {
            E o1 = array[i];
            Object o2 = that.get(i);
            if (Objects.equals(o1, o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int size = this.size;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                action.accept(this.asElement());
                break;
            }
            default: {
                E[] array = this.asArray();
                for (int i = 0; i < size; ++i) {
                    action.accept(array[i]);
                }
            }
        }
    }
}

