/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.PlaceholderResolver;
import cn.taketoday.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PropertyPlaceholderHandler {
    private static final Logger log = LoggerFactory.getLogger(PropertyPlaceholderHandler.class);
    public static final String PLACEHOLDER_SUFFIX = "}";
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String VALUE_SEPARATOR = ":";
    private static final HashMap<String, String> wellKnownSimplePrefixes = new HashMap(4);
    public static final PropertyPlaceholderHandler strict;
    public static final PropertyPlaceholderHandler nonStrict;
    private final String simplePrefix;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final int placeholderPrefixLength;
    private final int placeholderSuffixLength;
    @Nullable
    private final String valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;

    public PropertyPlaceholderHandler(String placeholderPrefix, String placeholderSuffix) {
        this(placeholderPrefix, placeholderSuffix, null, true);
    }

    public PropertyPlaceholderHandler(String placeholderPrefix, String placeholderSuffix, @Nullable String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull((Object)placeholderPrefix, "'placeholderPrefix' must not be null");
        Assert.notNull((Object)placeholderSuffix, "'placeholderSuffix' must not be null");
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(placeholderSuffix);
        this.simplePrefix = simplePrefixForSuffix != null && placeholderPrefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : placeholderPrefix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
        this.placeholderPrefixLength = placeholderPrefix.length();
        this.placeholderSuffixLength = placeholderSuffix.length();
    }

    public String replacePlaceholders(String value, Properties properties) {
        Assert.notNull((Object)properties, "'properties' must not be null");
        return this.replacePlaceholders(value, properties::getProperty);
    }

    public String replacePlaceholders(String value, PlaceholderResolver placeholderResolver) {
        Assert.notNull((Object)value, "'value' must not be null");
        return this.parseStringValue(value, placeholderResolver, null);
    }

    protected String parseStringValue(String value, PlaceholderResolver placeholderResolver, @Nullable Set<String> visitedPlaceholders) {
        int startIndex = value.indexOf(this.placeholderPrefix);
        if (startIndex == -1) {
            return value;
        }
        boolean traceEnabled = log.isTraceEnabled();
        StringBuilder result = new StringBuilder(value);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder;
                String originalPlaceholder = placeholder = result.substring(startIndex + this.placeholderPrefixLength, endIndex);
                if (visitedPlaceholders == null) {
                    visitedPlaceholders = new HashSet<String>(4);
                }
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                String propVal = placeholderResolver.resolvePlaceholder(placeholder = this.parseStringValue(placeholder, placeholderResolver, visitedPlaceholders));
                if (propVal == null && this.valueSeparator != null && (separatorIndex = placeholder.indexOf(this.valueSeparator)) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.length());
                    propVal = placeholderResolver.resolvePlaceholder(actualPlaceholder);
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                }
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, placeholderResolver, visitedPlaceholders);
                    result.replace(startIndex, endIndex + this.placeholderSuffixLength, propVal);
                    if (traceEnabled) {
                        log.trace("Resolved placeholder '{}'", (Object)placeholder);
                    }
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffixLength);
                } else {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in value \"" + value + "\"");
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefixLength;
        int withinNestedPlaceholder = 0;
        int length = buf.length();
        while (index < length) {
            if (StringUtils.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffixLength;
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch(buf, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    @NonNull
    public static PropertyPlaceholderHandler shared(boolean ignoreUnresolvablePlaceholders) {
        return ignoreUnresolvablePlaceholders ? nonStrict : strict;
    }

    static {
        wellKnownSimplePrefixes.put(PLACEHOLDER_SUFFIX, "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");
        strict = new PropertyPlaceholderHandler(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, VALUE_SEPARATOR, false);
        nonStrict = new PropertyPlaceholderHandler(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, VALUE_SEPARATOR, true);
    }
}

