/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import java.util.Map;
import java.util.Objects;

public final class KeyValueHolder<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private V value;

    public KeyValueHolder(K k, V v) {
        this.key = k;
        this.value = v;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public boolean equals(Object o) {
        Map.Entry e;
        if (o == this) {
            return true;
        }
        return o instanceof Map.Entry && Objects.equals(this.key, (e = (Map.Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

