/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.ReflectionException;
import cn.taketoday.util.ReflectionUtils;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class DefineClassHelper {
    private static final Method defineClass;
    private static final Throwable THROWABLE;
    private static final ProtectionDomain PROTECTION_DOMAIN;

    public static Class<?> defineClass(Class<?> neighbor, byte[] bcode) throws ReflectionException {
        try {
            DefineClassHelper.class.getModule().addReads(neighbor.getModule());
            MethodHandles.Lookup prvlookup = MethodHandles.privateLookupIn(neighbor, MethodHandles.lookup());
            return prvlookup.defineClass(bcode);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectionException(e.getMessage() + ": " + neighbor.getName() + " has no permission to define the class", e);
        }
    }

    public static Class<?> defineClass(String className, byte[] b, ClassLoader loader) throws CodeGenerationException {
        return DefineClassHelper.defineClass(className, null, loader, null, b);
    }

    public static Class<?> defineClass(String className, byte[] b, ClassLoader loader, ProtectionDomain protectionDomain) throws CodeGenerationException {
        return DefineClassHelper.defineClass(className, null, loader, protectionDomain, b);
    }

    public static Class<?> defineClass(String className, @Nullable Class<?> neighbor, ClassLoader loader, @Nullable ProtectionDomain domain, byte[] classFile) throws CodeGenerationException {
        MethodHandles.Lookup lookup;
        Class c = null;
        Throwable t = THROWABLE;
        if (neighbor != null && neighbor.getClassLoader() == loader) {
            try {
                lookup = MethodHandles.privateLookupIn(neighbor, MethodHandles.lookup());
                c = lookup.defineClass(classFile);
            }
            catch (IllegalArgumentException | LinkageError ex) {
                t = ex;
            }
            catch (Throwable ex) {
                throw DefineClassHelper.newException(className, ex);
            }
        }
        if (c == null) {
            if (domain == null) {
                domain = PROTECTION_DOMAIN;
            }
            if (defineClass != null) {
                try {
                    if (!defineClass.isAccessible()) {
                        defineClass.setAccessible(true);
                    }
                    c = (Class)defineClass.invoke((Object)loader, className, classFile, 0, classFile.length, domain);
                }
                catch (InvocationTargetException ex) {
                    throw new CodeGenerationException(ex.getTargetException());
                }
                catch (InaccessibleObjectException ex) {
                    t = ex;
                }
                catch (Throwable ex) {
                    throw DefineClassHelper.newException(className, ex);
                }
            }
            if (c == null) {
                try {
                    Method publicDefineClass = loader.getClass().getMethod("publicDefineClass", String.class, byte[].class, ProtectionDomain.class);
                    c = (Class)publicDefineClass.invoke((Object)loader, className, classFile, domain);
                }
                catch (InvocationTargetException ex) {
                    if (!(ex.getTargetException() instanceof UnsupportedOperationException)) {
                        throw new CodeGenerationException(ex.getTargetException());
                    }
                    t = ex.getTargetException();
                }
                catch (Throwable ex) {
                    t = ex;
                }
            }
        }
        if (c == null && neighbor != null && neighbor.getClassLoader() != loader) {
            try {
                lookup = MethodHandles.privateLookupIn(neighbor, MethodHandles.lookup());
                c = lookup.defineClass(classFile);
            }
            catch (IllegalAccessException ex) {
                throw new CodeGenerationException("ClassLoader mismatch for [" + neighbor.getName() + "]: JVM should be started with --add-opens=java.base/java.lang=ALL-UNNAMED for ClassLoader.defineClass to be accessible on " + loader.getClass().getName(), ex);
            }
            catch (Throwable ex) {
                throw DefineClassHelper.newException(className, ex);
            }
        }
        if (c == null) {
            throw DefineClassHelper.newException(className, t);
        }
        return c;
    }

    private static CodeGenerationException newException(String className, Throwable ex) {
        return new CodeGenerationException("Class: '" + className + "' define failed", ex);
    }

    static {
        Method classLoaderDefineClass;
        Throwable throwable = null;
        try {
            classLoaderDefineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
        }
        catch (Throwable t) {
            classLoaderDefineClass = null;
            throwable = t;
        }
        THROWABLE = throwable;
        defineClass = classLoaderDefineClass;
        PROTECTION_DOMAIN = ReflectionUtils.getProtectionDomain(DefineClassHelper.class);
    }
}

