/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;

public class DateUtils {
    public static LocalDateTime ofDateTime(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return (LocalDateTime)temporalAccessor;
        }
        return LocalDateTime.of(LocalDate.of(DateUtils.get(temporalAccessor, ChronoField.YEAR), DateUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), DateUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH)), LocalTime.of(DateUtils.get(temporalAccessor, ChronoField.HOUR_OF_DAY), DateUtils.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR)));
    }

    public static LocalTime ofTime(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalTime();
        }
        return LocalTime.of(DateUtils.get(temporalAccessor, ChronoField.HOUR_OF_DAY), DateUtils.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(DateUtils.get(temporalAccessor, ChronoField.YEAR), DateUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), DateUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            throw e;
        }
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        DateTimeFormatter formatter = StringUtils.isEmpty(format) ? null : DateTimeFormatter.ofPattern(format);
        return DateUtils.format(time, formatter);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        Assert.notNull((Object)temporalAccessor, "temporalAccessor must not be null");
        return DateUtils.toInstant(temporalAccessor).toEpochMilli();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }
}

