/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Constant;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;

public class AnnotationsAnnotatedElementAdapter
implements AnnotatedElement,
Serializable {
    @Nullable
    private final Annotation[] annotations;

    public AnnotationsAnnotatedElementAdapter(@Nullable Annotation[] annotations) {
        this.annotations = annotations;
    }

    @Override
    public boolean isAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(@NonNull Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations != null ? (Annotation[])this.annotations.clone() : Constant.EMPTY_ANNOTATIONS;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public boolean isEmpty() {
        return ObjectUtils.isEmpty(this.annotations);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof AnnotationsAnnotatedElementAdapter && Arrays.equals(this.annotations, ((AnnotationsAnnotatedElementAdapter)other).annotations);
    }

    public int hashCode() {
        return Arrays.hashCode(this.annotations);
    }
}

