/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.ReadOnlyPropertyAccessor;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class ReflectiveReadOnlyPropertyAccessor
extends ReadOnlyPropertyAccessor {
    @Nullable
    private final Field field;
    private final Method readMethod;

    ReflectiveReadOnlyPropertyAccessor(@Nullable Field field, Method readMethod) {
        this.field = field;
        this.readMethod = readMethod;
    }

    @Override
    public Object get(Object obj) {
        if (this.field != null) {
            return ReflectionUtils.getField(this.field, obj);
        }
        return ReflectionUtils.invokeMethod(this.readMethod, obj);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }
}

