/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.PropertyAccessor;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class ReflectivePropertyAccessor
extends PropertyAccessor {
    @Nullable
    private final Field field;
    private final Method readMethod;
    private final Method writeMethod;

    ReflectivePropertyAccessor(@Nullable Field field, @Nullable Method readMethod, @Nullable Method writeMethod) {
        this.field = field;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    @Override
    public Object get(Object obj) {
        if (this.field != null) {
            return ReflectionUtils.getField(this.field, obj);
        }
        return ReflectionUtils.invokeMethod(this.readMethod, obj);
    }

    @Override
    public void set(Object obj, Object value) {
        if (this.field != null) {
            ReflectionUtils.setField(this.field, obj, value);
        } else {
            ReflectionUtils.invokeMethod(this.writeMethod, obj, value);
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }
}

