/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.GetterMethod;
import cn.taketoday.reflect.GetterSetterPropertyAccessor;
import cn.taketoday.reflect.MethodAccessorPropertyAccessor;
import cn.taketoday.reflect.MethodInvoker;
import cn.taketoday.reflect.ReadOnlyGetterMethodPropertyAccessor;
import cn.taketoday.reflect.ReadOnlyMethodAccessorPropertyAccessor;
import cn.taketoday.reflect.ReflectionException;
import cn.taketoday.reflect.ReflectivePropertyAccessor;
import cn.taketoday.reflect.ReflectiveReadOnlyPropertyAccessor;
import cn.taketoday.reflect.SetterMethod;
import cn.taketoday.reflect.WriteOnlyPropertyAccessor;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class PropertyAccessor
implements SetterMethod,
GetterMethod {
    @Override
    public abstract Object get(Object var1);

    @Override
    public abstract void set(Object var1, Object var2);

    public boolean isReadOnly() {
        return false;
    }

    public static PropertyAccessor fromField(Field field) {
        Method readMethod = ReflectionUtils.getReadMethod(field);
        boolean isReadOnly = Modifier.isFinal(field.getModifiers());
        if (isReadOnly && readMethod != null) {
            MethodInvoker invoker = MethodInvoker.fromMethod(readMethod);
            return new ReadOnlyMethodAccessorPropertyAccessor(invoker);
        }
        Method writeMethod = ReflectionUtils.getWriteMethod(field);
        if (writeMethod != null && readMethod != null) {
            return PropertyAccessor.fromMethod(readMethod, writeMethod);
        }
        if (writeMethod != null) {
            MethodInvoker accessor = MethodInvoker.fromMethod(writeMethod);
            ReflectionUtils.makeAccessible(field);
            return PropertyAccessor.getPropertyAccessor(field, accessor, writeMethod);
        }
        if (readMethod != null) {
            ReflectionUtils.makeAccessible(field);
            MethodInvoker accessor = MethodInvoker.fromMethod(readMethod);
            return PropertyAccessor.getPropertyAccessor(accessor, field, readMethod);
        }
        return PropertyAccessor.fromReflective(field);
    }

    public static PropertyAccessor from(Class<?> targetClass, String name) {
        Field field = ReflectionUtils.findField(targetClass, name);
        if (field == null) {
            throw new ReflectionException("No such property: '" + name + "' in class: " + targetClass);
        }
        return PropertyAccessor.fromField(field);
    }

    public static PropertyAccessor fromMethod(@Nullable Method readMethod, final @Nullable Method writeMethod) {
        if (readMethod != null) {
            MethodInvoker readInvoker = MethodInvoker.fromMethod(readMethod);
            if (writeMethod == null) {
                return new ReadOnlyMethodAccessorPropertyAccessor(readInvoker);
            }
            return new MethodAccessorPropertyAccessor(readInvoker, MethodInvoker.fromMethod(writeMethod));
        }
        if (writeMethod != null) {
            final MethodInvoker writeInvoker = MethodInvoker.fromMethod(writeMethod);
            return new WriteOnlyPropertyAccessor(){

                @Override
                public Method getWriteMethod() {
                    return writeMethod;
                }

                @Override
                public void set(Object obj, Object value) {
                    writeInvoker.invoke(obj, new Object[]{value});
                }
            };
        }
        throw new IllegalArgumentException("read-write cannot be null at the same time");
    }

    public static PropertyAccessor fromMethod(GetterMethod readMethod, @Nullable SetterMethod writeMethod) {
        Assert.notNull((Object)readMethod, "readMethod must not be null");
        if (writeMethod != null) {
            return new GetterSetterPropertyAccessor(readMethod, writeMethod);
        }
        return new ReadOnlyGetterMethodPropertyAccessor(readMethod);
    }

    public static PropertyAccessor fromField(Field field, @Nullable Method readMethod, @Nullable Method writeMethod) {
        boolean isReadOnly;
        boolean bl = isReadOnly = Modifier.isFinal(field.getModifiers()) && writeMethod == null;
        if (isReadOnly && readMethod != null) {
            MethodInvoker invoker = MethodInvoker.fromMethod(readMethod);
            return new ReadOnlyMethodAccessorPropertyAccessor(invoker);
        }
        if (writeMethod != null && readMethod != null) {
            return PropertyAccessor.fromMethod(readMethod, writeMethod);
        }
        if (writeMethod != null) {
            MethodInvoker accessor = MethodInvoker.fromMethod(writeMethod);
            ReflectionUtils.makeAccessible(field);
            return PropertyAccessor.getPropertyAccessor(field, accessor, writeMethod);
        }
        if (readMethod != null) {
            ReflectionUtils.makeAccessible(field);
            MethodInvoker accessor = MethodInvoker.fromMethod(readMethod);
            return PropertyAccessor.getPropertyAccessor(accessor, field, readMethod);
        }
        return PropertyAccessor.fromReflective(field);
    }

    private static PropertyAccessor getPropertyAccessor(final Field field, final MethodInvoker accessor, final @NonNull Method writeMethod) {
        return new PropertyAccessor(){

            @Override
            public Object get(Object obj) {
                return ReflectionUtils.getField(field, obj);
            }

            @Override
            public void set(Object obj, Object value) {
                accessor.invoke(obj, new Object[]{value});
            }

            @Override
            public Method getWriteMethod() {
                return writeMethod;
            }
        };
    }

    private static PropertyAccessor getPropertyAccessor(final MethodInvoker accessor, final Field field, final @NonNull Method readMethod) {
        return new PropertyAccessor(){

            @Override
            public Object get(Object obj) {
                return accessor.invoke(obj, null);
            }

            @Override
            public void set(Object obj, Object value) {
                ReflectionUtils.setField(field, obj, value);
            }

            @Override
            public Method getReadMethod() {
                return readMethod;
            }
        };
    }

    public static PropertyAccessor fromReflective(Field field) {
        return PropertyAccessor.fromReflective(field, null, null);
    }

    public static PropertyAccessor fromReflective(@Nullable Field field, @Nullable Method readMethod, @Nullable Method writeMethod) {
        boolean readOnly;
        if (field != null) {
            ReflectionUtils.makeAccessible(field);
            readOnly = Modifier.isFinal(field.getModifiers());
        } else {
            Assert.notNull((Object)readMethod, "read-method is required");
            boolean bl = readOnly = writeMethod == null;
        }
        if (readOnly) {
            return new ReflectiveReadOnlyPropertyAccessor(field, readMethod);
        }
        return new ReflectivePropertyAccessor(field, readMethod, writeMethod);
    }
}

