/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Property
implements Member,
AnnotatedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentReferenceHashMap<Property, Annotation[]> annotationCache = new ConcurrentReferenceHashMap();
    protected transient Field field;
    @Nullable
    private transient TypeDescriptor typeDescriptor;
    protected final String name;
    @Nullable
    protected final Method readMethod;
    @Nullable
    protected final Method writeMethod;
    private Class<?> propertyType;
    private Class<?> declaringClass;
    private boolean fieldIsNull;
    @Nullable
    private transient Annotation[] annotations;
    private ResolvableType resolvableType;
    private transient MethodParameter methodParameter;
    protected transient MethodParameter writeMethodParameter;

    public Property(String name, Field field) {
        this.name = name;
        this.field = field;
        this.propertyType = field.getType();
        this.readMethod = null;
        this.writeMethod = null;
    }

    public Property(Field field) {
        this(field.getName(), field);
    }

    public Property(@Nullable Method readMethod, @Nullable Method writeMethod, @Nullable Class<?> declaringClass) {
        this(null, readMethod, writeMethod, declaringClass);
    }

    public Property(@Nullable String name, @Nullable Method readMethod, @Nullable Method writeMethod, @Nullable Class<?> declaringClass) {
        if (readMethod == null && writeMethod == null) {
            throw new IllegalArgumentException("Property '" + name + "' in '" + declaringClass + "' is neither readable nor writeable");
        }
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.declaringClass = declaringClass;
        if (name == null) {
            name = ReflectionUtils.getPropertyName(readMethod, writeMethod);
        }
        this.name = name;
    }

    public final TypeDescriptor getTypeDescriptor() {
        TypeDescriptor typeDescriptor = this.typeDescriptor;
        if (typeDescriptor == null) {
            this.typeDescriptor = typeDescriptor = this.createDescriptor();
        }
        return typeDescriptor;
    }

    protected TypeDescriptor createDescriptor() {
        ResolvableType resolvableType = ResolvableType.forMethodParameter(this.getMethodParameter());
        return new TypeDescriptor(resolvableType, resolvableType.resolve(this.getType()), this);
    }

    public ResolvableType getResolvableType() {
        ResolvableType resolvableType = this.resolvableType;
        if (resolvableType == null) {
            this.resolvableType = resolvableType = this.createResolvableType();
        }
        return resolvableType;
    }

    protected ResolvableType createResolvableType() {
        Method readMethod = this.getReadMethod();
        if (readMethod != null) {
            return ResolvableType.forReturnType(readMethod, this.getDeclaringClass());
        }
        Method writeMethod = this.getWriteMethod();
        if (writeMethod != null) {
            return ResolvableType.forParameter(writeMethod, 0, this.getDeclaringClass());
        }
        throw new IllegalStateException("never get here");
    }

    public boolean isInstance(Object value) {
        return this.getType().isInstance(value);
    }

    public Class<?> getType() {
        if (this.propertyType == null) {
            if (this.readMethod != null) {
                this.propertyType = this.readMethod.getReturnType();
            } else if (this.writeMethod != null) {
                this.propertyType = this.writeMethod.getParameterTypes()[0];
            } else {
                throw new IllegalStateException("should never get here");
            }
        }
        return this.propertyType;
    }

    @Nullable
    public Field getField() {
        if (this.field == null && !this.fieldIsNull) {
            String name = this.getName();
            if (StringUtils.isEmpty(name)) {
                return null;
            }
            Class<?> declaringClass = this.getDeclaringClass();
            if (declaringClass != null) {
                this.field = ReflectionUtils.findField(declaringClass, name);
                if (this.field == null) {
                    this.field = ReflectionUtils.findField(declaringClass, StringUtils.uncapitalize(name));
                    if (this.field == null) {
                        this.field = ReflectionUtils.findField(declaringClass, StringUtils.capitalize(name));
                    }
                }
            }
            this.fieldIsNull = this.field == null;
        }
        return this.field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        if (this.readMethod != null) {
            return this.readMethod.getModifiers();
        }
        if (this.writeMethod != null) {
            return this.writeMethod.getModifiers();
        }
        return 2;
    }

    @Override
    public boolean isSynthetic() {
        if (this.readMethod != null) {
            return this.readMethod.isSynthetic();
        }
        if (this.writeMethod != null) {
            return this.writeMethod.isSynthetic();
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.writeMethod == null;
    }

    public boolean isWriteable() {
        return this.writeMethod != null;
    }

    public boolean isReadable() {
        return this.readMethod != null;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    @Override
    public Class<?> getDeclaringClass() {
        if (this.declaringClass == null) {
            if (this.readMethod != null) {
                this.declaringClass = this.readMethod.getDeclaringClass();
            } else if (this.writeMethod != null) {
                this.declaringClass = this.writeMethod.getDeclaringClass();
            }
        }
        return this.declaringClass;
    }

    @Nullable
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Nullable
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Nullable
    public MethodParameter getWriteMethodParameter() {
        MethodParameter writeMethodParameter = this.writeMethodParameter;
        if (writeMethodParameter == null && this.getWriteMethod() != null) {
            this.writeMethodParameter = writeMethodParameter = new MethodParameter(this.getWriteMethod(), 0).withContainingClass(this.getDeclaringClass());
        }
        return writeMethodParameter;
    }

    @Nullable
    public MethodParameter getMethodParameter() {
        MethodParameter methodParameter = this.methodParameter;
        if (methodParameter == null) {
            this.methodParameter = methodParameter = this.resolveMethodParameter();
        }
        return methodParameter;
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter read = this.resolveReadMethodParameter();
        MethodParameter write = this.getWriteMethodParameter();
        if (write == null) {
            if (read == null) {
                throw new IllegalStateException("Property '" + this.name + "' in '" + this.declaringClass + "' is neither readable nor writeable");
            }
            return read;
        }
        if (read != null) {
            Class<?> readType = read.getParameterType();
            Class<?> writeType = write.getParameterType();
            if (!writeType.equals(readType) && writeType.isAssignableFrom(readType)) {
                return read;
            }
        }
        return write;
    }

    @Nullable
    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getReadMethod(), -1).withContainingClass(this.getDeclaringClass());
    }

    @Override
    public boolean isAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(@NonNull Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    private Annotation[] resolveAnnotations() {
        Annotation[] annotations = annotationCache.get(this);
        if (annotations == null) {
            LinkedHashMap<Class<? extends Annotation>, Annotation> annotationMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            this.addAnnotationsToMap(annotationMap, this.getReadMethod());
            this.addAnnotationsToMap(annotationMap, this.getWriteMethod());
            this.addAnnotationsToMap(annotationMap, this.getField());
            annotations = annotationMap.values().toArray(Constant.EMPTY_ANNOTATIONS);
            annotationCache.put(this, annotations);
        }
        return annotations;
    }

    private void addAnnotationsToMap(Map<Class<? extends Annotation>, Annotation> annotationMap, @Nullable AnnotatedElement object) {
        if (object != null) {
            for (Annotation annotation : object.getAnnotations()) {
                annotationMap.put(annotation.annotationType(), annotation);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Property) {
            Property property = (Property)o;
            return Objects.equals(this.name, property.name) && Objects.equals(this.readMethod, property.readMethod) && Objects.equals(this.writeMethod, property.writeMethod) && Objects.equals(this.propertyType, property.propertyType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.name, this.readMethod, this.writeMethod);
    }

    public String toString() {
        return this.getType().getSimpleName() + " " + this.getName();
    }
}

