/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.ClassGenerator;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.lang.Assert;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.reflect.GeneratorSupport;
import cn.taketoday.reflect.Invoker;
import cn.taketoday.reflect.MethodAccessor;
import cn.taketoday.reflect.ReflectionException;
import cn.taketoday.reflect.ReflectiveMethodAccessor;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public abstract class MethodInvoker
implements MethodAccessor,
Invoker {
    private final Method method;

    public MethodInvoker(Method method) {
        Assert.notNull((Object)method, "method must not be null");
        this.method = method;
    }

    @Override
    public abstract Object invoke(Object var1, Object[] var2);

    @Override
    public Method getMethod() {
        return this.method;
    }

    public static MethodInvoker fromMethod(Method executable) {
        Assert.notNull((Object)executable, "method must not be null");
        return (MethodInvoker)new MethodInvokerGenerator(executable).create();
    }

    public static MethodInvoker fromMethod(Method executable, Class<?> targetClass) {
        Assert.notNull((Object)executable, "method must not be null");
        return (MethodInvoker)new MethodInvokerGenerator(executable, targetClass).create();
    }

    public static MethodInvoker fromMethod(Class<?> beanClass, String name, Class<?> ... parameters) {
        try {
            Method targetMethod = beanClass.getDeclaredMethod(name, parameters);
            return (MethodInvoker)new MethodInvokerGenerator(targetMethod, beanClass).create();
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("No such method: '" + name + "' in " + beanClass, e);
        }
    }

    public static MethodInvoker formReflective(Method method) {
        return MethodInvoker.formReflective(method, true);
    }

    public static MethodInvoker formReflective(Method method, boolean handleReflectionException) {
        Assert.notNull((Object)method, "Method is required");
        ReflectionUtils.makeAccessible(method);
        return new ReflectiveMethodAccessor(method, handleReflectionException);
    }

    public static class MethodInvokerGenerator
    extends GeneratorSupport<MethodInvoker>
    implements ClassGenerator {
        private static final String superType = "Lcn/taketoday/reflect/MethodInvoker;";
        private static final String[] interfaces = new String[]{"Lcn/taketoday/reflect/Invoker;"};
        private static final MethodInfo invokeInfo = MethodInfo.from(ReflectionUtils.getMethod(MethodInvoker.class, "invoke", Object.class, Object[].class));
        private static final MethodSignature SIG_CONSTRUCTOR = new MethodSignature("<init>", "(Ljava/lang/reflect/Method;)V");
        private final Method targetMethod;

        public MethodInvokerGenerator(Method method) {
            super(method.getDeclaringClass());
            this.targetMethod = method;
        }

        public MethodInvokerGenerator(Method method, Class<?> targetClass) {
            super(targetClass);
            this.targetMethod = ReflectionUtils.getMostSpecificMethod(method, targetClass);
        }

        @Override
        public void generateClass(ClassVisitor v) {
            ClassEmitter classEmitter = this.beginClass(v);
            CodeEmitter codeEmitter = EmitUtils.beginMethod(classEmitter, invokeInfo, 17);
            if (!Modifier.isStatic(this.targetMethod.getModifiers())) {
                codeEmitter.visitVarInsn(25, 1);
                codeEmitter.checkCast(Type.fromClass(this.targetClass));
            }
            this.prepareParameters(codeEmitter, this.targetMethod);
            MethodInfo methodInfo = MethodInfo.from(this.targetMethod);
            codeEmitter.invoke(methodInfo);
            codeEmitter.valueOf(Type.fromClass(this.targetMethod.getReturnType()));
            codeEmitter.returnValue();
            codeEmitter.end_method();
            classEmitter.endClass();
        }

        @Override
        protected void generateConstructor(ClassEmitter ce) {
            CodeEmitter e = ce.beginMethod(1, SIG_CONSTRUCTOR, new Type[0]);
            e.loadThis();
            e.loadArg(0);
            e.super_invoke_constructor(SIG_CONSTRUCTOR);
            e.returnValue();
            e.end_method();
        }

        @Override
        protected MethodInvoker newInstance(Class<MethodInvoker> accessorClass) throws NoSuchMethodException {
            Constructor<MethodInvoker> constructor = accessorClass.getDeclaredConstructor(Method.class);
            return ReflectionUtils.invokeConstructor(constructor, new Object[]{this.targetMethod});
        }

        @Override
        protected void appendClassName(StringBuilder builder) {
            builder.append('$').append(this.targetMethod.getName());
            this.buildClassNameSuffix(builder, this.targetMethod);
        }

        @Override
        protected MethodInvoker fallback(Exception exception) {
            LoggerFactory.getLogger(MethodInvokerGenerator.class).warn("Cannot access a Method: [{}], using fallback instance", (Object)this.targetMethod, (Object)exception);
            return (MethodInvoker)super.fallback(exception);
        }

        @Override
        protected MethodInvoker fallbackInstance() {
            return MethodInvoker.formReflective(this.targetMethod);
        }

        @Override
        protected boolean cannotAccess() {
            return Modifier.isPrivate(this.targetClass.getModifiers()) || Modifier.isPrivate(this.targetMethod.getModifiers());
        }

        @Override
        protected ClassGenerator getClassGenerator() {
            return this;
        }

        @Override
        protected Object cacheKey() {
            return new MethodInvokerCacheKey(this.targetMethod, this.targetClass);
        }

        @Override
        public String getSuperType() {
            return superType;
        }

        @Override
        public String[] getInterfaces() {
            return interfaces;
        }
    }

    static class MethodInvokerCacheKey {
        int hash;
        final Method targetMethod;
        final Class<?> targetClass;

        MethodInvokerCacheKey(Method targetMethod, Class<?> targetClass) {
            this.targetMethod = targetMethod;
            this.targetClass = targetClass;
            this.hash = Objects.hash(targetMethod, targetClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodInvokerCacheKey)) {
                return false;
            }
            MethodInvokerCacheKey that = (MethodInvokerCacheKey)o;
            return Objects.equals(this.targetMethod, that.targetMethod) && Objects.equals(this.targetClass, that.targetClass);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

