/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.Level;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.MessageFormatter;
import cn.taketoday.logging.Slf4jLoggerFactory;

class Slf4jLogger
extends Logger {
    protected final String name;
    private final transient org.slf4j.Logger target;

    Slf4jLogger(org.slf4j.Logger target) {
        super(target.isDebugEnabled());
        this.target = target;
        this.name = target.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.debugEnabled && this.target.isTraceEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.target.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.target.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.target.isErrorEnabled();
    }

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    protected void logInternal(Level level, Object msg, Throwable t) {
        String message = String.valueOf(msg);
        this.logInternal(level, message, t, null);
    }

    @Override
    protected void logInternal(Level level, String format, Throwable t, Object[] args) {
        String msg = MessageFormatter.format(format, args);
        switch (level) {
            case DEBUG: {
                this.target.debug(msg, t);
                break;
            }
            case ERROR: {
                this.target.error(msg, t);
                break;
            }
            case TRACE: {
                this.target.trace(msg, t);
                break;
            }
            case WARN: {
                this.target.warn(msg, t);
                break;
            }
            default: {
                this.target.info(msg, t);
            }
        }
    }

    protected Object readResolve() {
        return Slf4jLoggerFactory.createLog(this.name);
    }
}

