/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.Level;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.MessageFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;

final class Log4j2Logger
extends Logger {
    static final LoggerContext loggerContext = LogManager.getContext((ClassLoader)Log4j2Logger.class.getClassLoader(), (boolean)false);
    private final ExtendedLogger logger;

    Log4j2Logger(ExtendedLogger logger) {
        super(logger.isDebugEnabled());
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.debugEnabled && this.logger.isTraceEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    private org.apache.logging.log4j.Level getLevel(Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Level.INFO -> org.apache.logging.log4j.Level.INFO;
            case Level.WARN -> org.apache.logging.log4j.Level.WARN;
            case Level.DEBUG -> org.apache.logging.log4j.Level.DEBUG;
            case Level.TRACE -> org.apache.logging.log4j.Level.TRACE;
            case Level.ERROR -> org.apache.logging.log4j.Level.ERROR;
        };
    }

    @Override
    protected void logInternal(Level level, Object message, Throwable t) {
        if (message instanceof String) {
            if (t != null) {
                this.logger.logIfEnabled(FQCN, this.getLevel(level), null, (String)message, t);
            } else {
                this.logger.logIfEnabled(FQCN, this.getLevel(level), null, (String)message);
            }
        } else {
            this.logger.logIfEnabled(FQCN, this.getLevel(level), null, message, t);
        }
    }

    @Override
    protected void logInternal(Level level, final String format, final Throwable t, final Object[] args) {
        Message message = new Message(){
            private static final long serialVersionUID = 1L;
            private String msg;

            public Throwable getThrowable() {
                return t;
            }

            public Object[] getParameters() {
                return args;
            }

            public String getFormattedMessage() {
                if (this.msg == null) {
                    this.msg = MessageFormatter.format(format, args);
                }
                return this.msg;
            }

            public String getFormat() {
                return this.msg;
            }
        };
        this.logger.logIfEnabled(FQCN, this.getLevel(level), null, message, t);
    }
}

