/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.lang;

import cn.taketoday.lang.Descriptive;
import cn.taketoday.lang.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public interface Enumerable<V>
extends Descriptive {
    default public V getValue() {
        return (V)this.name();
    }

    @Override
    default public String getDescription() {
        return this.name();
    }

    public String name();

    @Nullable
    public static <T extends Enumerable<V>, V> T of(Class<T> enumerable, @Nullable V value) {
        Enumerable[] enumConstants;
        if (value != null && (enumConstants = (Enumerable[])enumerable.getEnumConstants()) != null) {
            for (Enumerable constant : enumConstants) {
                if (!Objects.equals(value, constant.getValue())) continue;
                return (T)constant;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends Enumerable<V>, V> V getValue(Class<T> enumerable, String name) {
        Enumerable[] enumConstants = (Enumerable[])enumerable.getEnumConstants();
        if (enumConstants != null) {
            for (Enumerable constant : enumConstants) {
                if (!Objects.equals(name, constant.name())) continue;
                return constant.getValue();
            }
        }
        return null;
    }

    public static <T extends Enumerable<V>, V> T of(Class<T> enumerable, V value, Supplier<T> defaultValue) {
        return (T)((Enumerable)Enumerable.find(enumerable, value).orElseGet(defaultValue));
    }

    public static <T extends Enumerable<V>, V> T of(Class<T> enumerable, V value, T defaultValue) {
        return (T)((Enumerable)Enumerable.find(enumerable, value).orElse(defaultValue));
    }

    public static <T extends Enumerable<V>, V> Optional<T> find(Class<T> enumerable, V value) {
        return Optional.ofNullable(Enumerable.of(enumerable, value));
    }
}

