/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.support;

import cn.taketoday.core.DefaultAliasRegistry;
import cn.taketoday.expression.EvaluationException;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.TypeLocator;
import cn.taketoday.expression.spel.SpelEvaluationException;
import cn.taketoday.expression.spel.SpelMessage;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class StandardTypeLocator
extends DefaultAliasRegistry
implements TypeLocator {
    @Nullable
    private final ClassLoader classLoader;
    private final HashMap<String, Class<?>> classMap = new HashMap();
    private final HashMap<String, String> classNameMap = new HashMap();
    private final HashSet<String> notAClass = new HashSet();
    private final ArrayList<String> packages = new ArrayList(1);

    public StandardTypeLocator() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public StandardTypeLocator(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.registerImport("java.lang");
    }

    public void registerImport(String prefix) {
        this.packages.add(prefix);
    }

    public void removeImport(String prefix) {
        this.packages.remove(prefix);
    }

    public List<String> getImportPrefixes() {
        return Collections.unmodifiableList(this.packages);
    }

    public void importClass(String name) throws ExpressionException {
        int i = name.lastIndexOf(46);
        if (i <= 0) {
            throw new ExpressionException("The name " + name + " is not a full class name");
        }
        String className = ClassUtils.getShortName(name);
        this.classNameMap.put(className, name);
    }

    public void importClass(Class<?> classToImport) {
        String className = classToImport.getName();
        String simpleName = ClassUtils.getSimpleName(className);
        this.classMap.put(simpleName, classToImport);
        this.classMap.put(className, classToImport);
        this.notAClass.remove(simpleName);
        this.notAClass.remove(className);
    }

    public void registerAlias(Class<?> classToImport, String ... alias) {
        this.importClass(classToImport);
        for (String alia : alias) {
            this.registerAlias(classToImport.getName(), alia);
        }
    }

    @Override
    public Class<?> findType(String typeName) throws EvaluationException {
        Class<?> type;
        String className = this.classNameMap.get(typeName);
        if (className == null) {
            className = this.canonicalName(typeName);
        }
        if ((type = this.resolveClassFor(className)) != null) {
            return type;
        }
        for (String packageName : this.packages) {
            String fullClassName = packageName + "." + className;
            Class<?> c = this.resolveClassFor(fullClassName);
            if (c == null) continue;
            this.classNameMap.put(typeName, fullClassName);
            return c;
        }
        throw new SpelEvaluationException(SpelMessage.TYPE_NOT_FOUND, typeName);
    }

    @Nullable
    private Class<?> resolveClassFor(String className) {
        Class<?> c = this.classMap.get(className);
        if (c != null) {
            return c;
        }
        c = this.getClassFor(className);
        if (c != null) {
            this.classMap.put(className, c);
        }
        return c;
    }

    @Nullable
    public Class<?> getClassFor(String className) {
        if (!this.notAClass.contains(className)) {
            Object nameToLookup = className;
            try {
                return ClassUtils.forName((String)nameToLookup, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                for (String prefix : this.packages) {
                    try {
                        nameToLookup = prefix + "." + className;
                        return ClassUtils.forName((String)nameToLookup, this.classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                    }
                }
                this.notAClass.add(className);
            }
        }
        return null;
    }
}

