/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.standard;

import cn.taketoday.expression.spel.standard.TokenKind;
import cn.taketoday.lang.Nullable;

class Token {
    public TokenKind kind;
    @Nullable
    public String data;
    public int startPos;
    public int endPos;

    public Token(TokenKind tokenKind, int startPos, int endPos) {
        this.kind = tokenKind;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public Token(TokenKind tokenKind, char[] tokenData, int startPos, int endPos) {
        this(tokenKind, startPos, endPos);
        this.data = new String(tokenData);
    }

    public boolean isIdentifier() {
        return this.kind == TokenKind.IDENTIFIER;
    }

    public boolean isNumericRelationalOperator() {
        return this.kind == TokenKind.GT || this.kind == TokenKind.GE || this.kind == TokenKind.LT || this.kind == TokenKind.LE || this.kind == TokenKind.EQ || this.kind == TokenKind.NE;
    }

    public String stringValue() {
        return this.data != null ? this.data : "";
    }

    public Token asInstanceOfToken() {
        return new Token(TokenKind.INSTANCEOF, this.startPos, this.endPos);
    }

    public Token asMatchesToken() {
        return new Token(TokenKind.MATCHES, this.startPos, this.endPos);
    }

    public Token asBetweenToken() {
        return new Token(TokenKind.BETWEEN, this.startPos, this.endPos);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('[').append((Object)this.kind);
        if (this.kind.hasPayload()) {
            s.append(':').append(this.data);
        }
        s.append(']');
        s.append('(').append(this.startPos).append(',').append(this.endPos).append(')');
        return s.toString();
    }
}

