/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.ast;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.core.CodeFlow;
import cn.taketoday.expression.TypedValue;
import cn.taketoday.expression.spel.ast.Literal;
import cn.taketoday.lang.Assert;

public class IntLiteral
extends Literal {
    private final TypedValue value;

    public IntLiteral(String payload, int startPos, int endPos, int value) {
        super(payload, startPos, endPos);
        this.value = new TypedValue(value);
        this.exitTypeDescriptor = "I";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        Integer intValue = (Integer)this.value.getValue();
        Assert.state(intValue != null, "No int value");
        if (intValue == -1) {
            mv.visitInsn(2);
        } else if (intValue >= 0 && intValue < 6) {
            mv.visitInsn(3 + intValue);
        } else {
            mv.visitLdcInsn(intValue);
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

