/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.ast;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.core.CodeFlow;
import cn.taketoday.expression.TypedValue;
import cn.taketoday.expression.spel.ast.Literal;

public class FloatLiteral
extends Literal {
    private final TypedValue value;

    public FloatLiteral(String payload, int startPos, int endPos, float value) {
        super(payload, startPos, endPos);
        this.value = new TypedValue(Float.valueOf(value));
        this.exitTypeDescriptor = "F";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        mv.visitLdcInsn(this.value.getValue());
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

