/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.filter;

import cn.taketoday.core.type.ClassMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.io.IOException;

public abstract class AbstractTypeHierarchyTraversingFilter
implements TypeFilter {
    private static final Logger log = LoggerFactory.getLogger(AbstractTypeHierarchyTraversingFilter.class);
    private final boolean considerInherited;
    private final boolean considerInterfaces;

    protected AbstractTypeHierarchyTraversingFilter(boolean considerInherited, boolean considerInterfaces) {
        this.considerInherited = considerInherited;
        this.considerInterfaces = considerInterfaces;
    }

    @Override
    public boolean match(MetadataReader metadataReader, MetadataReaderFactory factory) throws IOException {
        ClassMetadata metadata;
        block15: {
            String superClassName;
            if (this.matchSelf(metadataReader)) {
                return true;
            }
            metadata = metadataReader.getClassMetadata();
            if (this.matchClassName(metadata.getClassName())) {
                return true;
            }
            if (this.considerInherited && (superClassName = metadata.getSuperClassName()) != null) {
                Boolean superClassMatch = this.matchSuperClass(superClassName);
                if (superClassMatch != null) {
                    if (superClassMatch.booleanValue()) {
                        return true;
                    }
                } else {
                    try {
                        if (this.match(metadata.getSuperClassName(), factory)) {
                            return true;
                        }
                    }
                    catch (IOException ex) {
                        if (!log.isDebugEnabled()) break block15;
                        log.debug("Could not read super class [{}] of type-filtered class [{]]", (Object)metadata.getSuperClassName(), (Object)metadata.getClassName());
                    }
                }
            }
        }
        if (this.considerInterfaces) {
            for (String ifc : metadata.getInterfaceNames()) {
                Boolean interfaceMatch = this.matchInterface(ifc);
                if (interfaceMatch != null) {
                    if (!interfaceMatch.booleanValue()) continue;
                    return true;
                }
                try {
                    if (this.match(ifc, factory)) {
                        return true;
                    }
                }
                catch (IOException ex) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Could not read interface [{}] for type-filtered class [{]]", (Object)ifc, (Object)metadata.getClassName());
                }
            }
        }
        return false;
    }

    private boolean match(String className, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return this.match(metadataReaderFactory.getMetadataReader(className), metadataReaderFactory);
    }

    protected boolean matchSelf(MetadataReader metadataReader) {
        return false;
    }

    protected boolean matchClassName(String className) {
        return false;
    }

    @Nullable
    protected Boolean matchSuperClass(String superClassName) {
        return null;
    }

    @Nullable
    protected Boolean matchInterface(String interfaceName) {
        return null;
    }
}

