/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.bytecode.ClassReader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.ClassMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.SimpleAnnotationMetadataReadingVisitor;
import cn.taketoday.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;

final class SimpleMetadataReader
implements MetadataReader {
    private static final int PARSING_OPTIONS = 7;
    private final Resource resource;
    private final AnnotationMetadata annotationMetadata;

    SimpleMetadataReader(Resource resource, @Nullable ClassLoader classLoader) throws IOException {
        SimpleAnnotationMetadataReadingVisitor visitor = new SimpleAnnotationMetadataReadingVisitor(classLoader);
        SimpleMetadataReader.getClassReader(resource).accept(visitor, 7);
        this.resource = resource;
        this.annotationMetadata = visitor.getMetadata();
    }

    private static ClassReader getClassReader(Resource resource) throws IOException {
        InputStream is = resource.getInputStream();
        try {
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("ASM ClassReader failed to parse class file - probably due to a new Java class file version that isn't supported yet: " + resource, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }
}

