/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

final class SimpleAnnotationMetadata
implements AnnotationMetadata {
    private final String className;
    private final int access;
    @Nullable
    private final String enclosingClassName;
    @Nullable
    private final String superClassName;
    private final boolean independentInnerClass;
    @Nullable
    private final Set<String> interfaceNames;
    @Nullable
    private final Set<String> memberClassNames;
    @Nullable
    private final Set<MethodMetadata> declaredMethods;
    private final MergedAnnotations annotations;
    @Nullable
    private Set<String> annotationTypes;

    SimpleAnnotationMetadata(String className, int access, @Nullable String enclosingClassName, @Nullable String superClassName, boolean independentInnerClass, @Nullable Set<String> interfaceNames, @Nullable Set<String> memberClassNames, @Nullable Set<MethodMetadata> declaredMethods, MergedAnnotations annotations) {
        this.access = access;
        this.className = className;
        this.annotations = annotations;
        this.superClassName = superClassName;
        this.enclosingClassName = enclosingClassName;
        this.independentInnerClass = independentInnerClass;
        this.interfaceNames = interfaceNames;
        this.declaredMethods = declaredMethods;
        this.memberClassNames = memberClassNames;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public int getModifiers() {
        return this.access;
    }

    @Override
    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    @Override
    @Nullable
    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    @Nullable
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        if (this.interfaceNames == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        return StringUtils.toStringArray(this.interfaceNames);
    }

    @Override
    public String[] getMemberClassNames() {
        if (this.memberClassNames == null) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        return StringUtils.toStringArray(this.memberClassNames);
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> annotationTypes = this.annotationTypes;
        if (annotationTypes == null) {
            this.annotationTypes = annotationTypes = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return annotationTypes;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        if (this.declaredMethods != null) {
            LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>(this.declaredMethods.size());
            for (MethodMetadata annotatedMethod : this.declaredMethods) {
                if (!annotatedMethod.isAnnotated(annotationName)) continue;
                annotatedMethods.add(annotatedMethod);
            }
            return annotatedMethods;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<MethodMetadata> getDeclaredMethods() {
        if (this.declaredMethods == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.declaredMethods);
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SimpleAnnotationMetadata && this.className.equals(((SimpleAnnotationMetadata)obj).className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return this.className;
    }
}

